/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.util;

import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class InfinityInvWrapper
implements IItemHandlerModifiable {
    private final Container inv;

    public InfinityInvWrapper(Container inv) {
        this.inv = inv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfinityInvWrapper that = (InfinityInvWrapper)o;
        return this.getInv().equals((Object)that.getInv());
    }

    public int hashCode() {
        return this.getInv().hashCode();
    }

    public int getSlots() {
        return this.getInv().getContainerSize();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getInv().getItem(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getItem(slot);
        stack.update((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get(), (Object)stack.getMaxStackSize(), size -> Integer.MAX_VALUE);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.max(stackInSlot.getMaxStackSize(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.getInv().canPlaceItem(slot, stack)) {
                return stack;
            }
            int m = Math.max(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.getInv().setItem(slot, copy);
                    this.getInv().setChanged();
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.getInv().setItem(slot, copy);
                this.getInv().setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.getInv().canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.max(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.getInv().setItem(slot, stack.split(m));
                this.getInv().setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.getInv().setItem(slot, stack);
            this.getInv().setChanged();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getItem(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                ItemStack stack = stackInSlot.copy();
                if (stack.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                    stack.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
                }
                return stack;
            }
            ItemStack stack = stackInSlot.copy();
            stack.setCount(amount);
            if (stack.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
                stack.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
            }
            return stack;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.getInv().removeItem(slot, m);
        this.getInv().setChanged();
        if (decrStackSize.has((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get())) {
            decrStackSize.remove((DataComponentType)AvaritiaDataComponents.MAX_STACK_SIZE.get());
        }
        return decrStackSize;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.getInv().setItem(slot, stack);
    }

    public int getSlotLimit(int slot) {
        return this.getInv().getMaxStackSize();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.getInv().canPlaceItem(slot, stack);
    }

    public Container getInv() {
        return this.inv;
    }
}

