/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.block;

import java.util.function.Supplier;
import net.byAqua3.avaritia.tile.TileMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockMachine
extends Block
implements EntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private static final Property<Direction> FACING = BlockStateProperties.FACING;
    private final Supplier<BlockEntityType<? extends TileMachine>> supplier;

    public BlockMachine(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends TileMachine>> supplier) {
        super(properties);
        this.supplier = supplier;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.supplier.get().create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return (world, blockPos, blockState, tile) -> ((TileMachine)tile).updateServer();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE, FACING});
    }
}

