/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IRuntimeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.byAqua3.avaritia.compat.jei.category.CategoryCollectorRecipe;
import net.byAqua3.avaritia.compat.jei.category.CategoryCompressorRecipe;
import net.byAqua3.avaritia.compat.jei.category.CategoryExtremeRecipe;
import net.byAqua3.avaritia.gui.GuiExtremeCraftingTable;
import net.byAqua3.avaritia.gui.GuiNeutroniumCompressor;
import net.byAqua3.avaritia.inventory.MenuExtremeCrafting;
import net.byAqua3.avaritia.inventory.MenuNeutroniumCompressor;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.loader.AvaritiaMenus;
import net.byAqua3.avaritia.recipe.RecipeCollector;
import net.byAqua3.avaritia.recipe.RecipeCompressor;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.util.RecipeUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@JeiPlugin
public class AvaritiaJEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_UID = ResourceLocation.tryBuild((String)"avaritia", (String)"plugin");
    public static final RecipeType<RecipeExtremeCrafting> EXTREME_CRAFTING = RecipeType.create((String)"avaritia", (String)"extreme_crafting", RecipeExtremeCrafting.class);
    public static final RecipeType<RecipeCompressor> COMPRESSOR = RecipeType.create((String)"avaritia", (String)"compressor", RecipeCompressor.class);
    public static final RecipeType<RecipeCollector> COLLECTOR = RecipeType.create((String)"avaritia", (String)"collector", RecipeCollector.class);

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CategoryExtremeRecipe(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CategoryCompressorRecipe(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CategoryCollectorRecipe(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        registration.addRecipes(EXTREME_CRAFTING, RecipeUtils.getExtremeCraftingRecipes((Level)level));
        registration.addRecipes(COMPRESSOR, RecipeUtils.getCompressorRecipes((Level)level));
        registration.addRecipes(COLLECTOR, RecipeUtils.getCollectorRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AvaritiaBlocks.COMPRESSED_CRAFTING_TABLE_ITEM.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AvaritiaBlocks.DOUBLE_COMPRESSED_CRAFTING_TABLE_ITEM.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AvaritiaBlocks.EXTREME_CRAFTING_TABLE_ITEM.get()), new RecipeType[]{EXTREME_CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AvaritiaBlocks.COMPRESSOR_ITEM.get()), new RecipeType[]{COMPRESSOR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)AvaritiaBlocks.NEUTRON_COLLECTOR_ITEM.get()), new RecipeType[]{COLLECTOR});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(MenuExtremeCrafting.class, (MenuType)AvaritiaMenus.EXTREME_CRAFTING.get(), EXTREME_CRAFTING, 1, 81, 82, 36);
        registration.addRecipeTransferHandler(MenuNeutroniumCompressor.class, (MenuType)AvaritiaMenus.COMPRESSOR.get(), COMPRESSOR, 0, 1, 2, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(GuiExtremeCraftingTable.class, 175, 79, 28, 26, new RecipeType[]{EXTREME_CRAFTING});
        registration.addRecipeClickArea(GuiNeutroniumCompressor.class, 62, 35, 22, 15, new RecipeType[]{COMPRESSOR});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)AvaritiaItems.JSON_SINGULARITY.get(), (stack, context) -> {
            String singularityId = (String)stack.getOrDefault(AvaritiaDataComponents.SINGULARITY_ID, (Object)"null");
            return singularityId;
        });
    }

    public void registerRuntime(IRuntimeRegistration registration) {
        IIngredientManager ingredientManager = registration.getIngredientManager();
        ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, List.of(new ItemStack((ItemLike)AvaritiaItems.MATTER_CLUSTER.get())));
    }
}

