/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.loader.AvaritiaRecipes;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class RecipeCompressor
implements RecipeExtremeCrafting {
    public final String group;
    public final ItemStack result;
    public final int cost;
    public final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;

    public RecipeCompressor(String group, ItemStack result, int cost, List<Ingredient> ingredients) {
        this.group = group;
        this.result = result;
        this.cost = cost;
        this.ingredients = NonNullList.copyOf(ingredients);
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    public boolean matches(CraftingInput container, Level level) {
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < container.size(); ++j) {
            ItemStack itemstack = container.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.accountStack(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && (this.isSimple ? stackedcontents.canCraft((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    public boolean showNotification() {
        return false;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider registryAccess) {
        return this.result.copy();
    }

    public String getGroup() {
        return this.group;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.result;
    }

    public int getCost() {
        return this.cost;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public RecipeType<?> getType() {
        return (RecipeType)AvaritiaRecipes.COMPRESSOR.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AvaritiaRecipes.COMPRESSOR_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<RecipeCompressor> {
        public static final MapCodec<RecipeCompressor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("cost").forGetter(recipe -> recipe.cost), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.ingredients)).apply((Applicative)instance, RecipeCompressor::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeCompressor> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<RecipeCompressor> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeCompressor> streamCodec() {
            return STREAM_CODEC;
        }

        private static RecipeCompressor fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
            String group = friendlyByteBuf.readUtf();
            int cost = friendlyByteBuf.readInt();
            int i = friendlyByteBuf.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf)));
            }
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf);
            return new RecipeCompressor(group, itemStack, cost, (List<Ingredient>)ingredients);
        }

        private static void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, RecipeCompressor recipe) {
            friendlyByteBuf.writeUtf(recipe.group);
            friendlyByteBuf.writeInt(recipe.cost);
            friendlyByteBuf.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)recipe.result);
        }
    }
}

