/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.singularity;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.byAqua3.avaritia.Avaritia;
import net.byAqua3.avaritia.loader.AvaritiaSingularities;
import net.byAqua3.avaritia.singularity.Singularity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.conditions.ConditionalOps;

public class SingularityManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private Map<ResourceLocation, Singularity> singularities = ImmutableMap.of();

    public SingularityManager() {
        super(GSON, "singularities");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ConditionalOps registryOps = this.makeConditionalOps();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Long lastTime = System.currentTimeMillis();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            try {
                Optional decoded = (Optional)Singularity.CONDITIONAL_CODEC.parse((DynamicOps)registryOps, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                decoded.ifPresentOrElse(r -> {
                    Singularity singularity = (Singularity)r.carrier();
                    builder.put((Object)resourcelocation, (Object)singularity);
                }, () -> Avaritia.LOGGER.debug("Skipping loading singularity {} as its conditions were not met", (Object)resourcelocation));
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                Avaritia.LOGGER.error("Parsing error loading singularity {}", (Object)resourcelocation, (Object)jsonParseException);
            }
        }
        this.singularities = builder.build().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
        AvaritiaSingularities.getInstance().getSingularities().clear();
        AvaritiaSingularities.getInstance().getSingularities().addAll(this.singularities.values());
        Avaritia.LOGGER.info("Loaded {} singularities took {}ms", (Object)this.singularities.size(), (Object)(System.currentTimeMillis() - lastTime));
    }
}

