/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.util;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class WrapperInfinityChest
implements IItemHandlerModifiable {
    private final Container inventory;

    public WrapperInfinityChest(Container inventory) {
        this.inventory = inventory;
    }

    public Container getInventory() {
        return this.inventory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrapperInfinityChest that = (WrapperInfinityChest)o;
        return this.getInventory().equals((Object)that.getInventory());
    }

    public int hashCode() {
        return this.getInventory().hashCode();
    }

    public int getSlots() {
        return this.getInventory().getContainerSize();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getInventory().getItem(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInventory().getItem(slot);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.min(this.getInventory().getMaxStackSize(stackInSlot), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.getInventory().canPlaceItem(slot, stack)) {
                return stack;
            }
            int m = Math.min(this.getInventory().getMaxStackSize(stack), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.getInventory().setItem(slot, copy);
                    this.getInventory().setChanged();
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.getInventory().setItem(slot, copy);
                this.getInventory().setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.getInventory().canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.min(this.getInventory().getMaxStackSize(stack), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.getInventory().setItem(slot, stack.split(m));
                this.getInventory().setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.getInventory().setItem(slot, stack);
            this.getInventory().setChanged();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInventory().getItem(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.getInventory().removeItem(slot, m);
        this.getInventory().setChanged();
        return decrStackSize;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.getInventory().setItem(slot, stack);
    }

    public int getSlotLimit(int slot) {
        return this.getInventory().getMaxStackSize();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.getInventory().canPlaceItem(slot, stack);
    }
}

