/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.RecipeUtil;
import java.util.List;
import net.byAqua3.avaritia.loader.AvaritiaRecipes;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeExtremeShaped;
import net.byAqua3.avaritia.recipe.RecipeExtremeShapeless;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="net.byAqua3.avaritia.ExtremeRecipe")
public class ExtremeRecipe
implements IRecipeManager<RecipeExtremeCrafting> {
    public static ExtremeRecipe recipeManager = new ExtremeRecipe();

    public RecipeType<RecipeExtremeCrafting> getRecipeType() {
        return (RecipeType)AvaritiaRecipes.EXTREME_CRAFTING.get();
    }

    @ZenCodeType.Method
    public static void addShaped(String name, String group, IIngredient[][] ingredients, IItemStack stack) {
        ItemStack itemStack = stack.getInternal();
        RecipeExtremeShaped recipe = new RecipeExtremeShaped(group, RecipeUtil.createPattern((IIngredient[][])ingredients), itemStack);
        RecipeHolder recipeHolder = new RecipeHolder(ResourceLocation.tryParse((String)name), (Recipe)recipe);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)recipeManager, recipeHolder));
    }

    @ZenCodeType.Method
    public static void addShapeless(String name, String group, IIngredient[] ingredients, IItemStack stack) {
        NonNullList list = NonNullList.create();
        ItemStack itemStack = stack.getInternal();
        for (IIngredient ingredient : ingredients) {
            list.add(ingredient.asVanillaIngredient());
        }
        RecipeExtremeShapeless recipe = new RecipeExtremeShapeless(group, itemStack, (List<Ingredient>)list, false);
        RecipeHolder recipeHolder = new RecipeHolder(ResourceLocation.tryParse((String)name), (Recipe)recipe);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)recipeManager, recipeHolder));
    }

    @ZenCodeType.Method
    public static void addShapeless(String name, String group, IIngredient[] ingredients, IItemStack stack, boolean hasSingularities) {
        NonNullList list = NonNullList.create();
        ItemStack itemStack = stack.getInternal();
        for (IIngredient ingredient : ingredients) {
            list.add(ingredient.asVanillaIngredient());
        }
        RecipeExtremeShapeless recipe = new RecipeExtremeShapeless(group, itemStack, (List<Ingredient>)list, hasSingularities);
        RecipeHolder recipeHolder = new RecipeHolder(ResourceLocation.tryParse((String)name), (Recipe)recipe);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)recipeManager, recipeHolder));
    }

    @ZenCodeType.Method
    public static void remove(String name) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)recipeManager, recipeHolder -> recipeHolder.id().equals((Object)ResourceLocation.tryParse((String)name))));
    }

    @ZenCodeType.Method
    public static void remove(IItemStack stack) {
        ItemStack itemStack = stack.getInternal();
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)recipeManager, recipeHolder -> ((RecipeExtremeCrafting)recipeHolder.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem() == itemStack.getItem()));
    }

    @ZenCodeType.Method
    public static void removeShaped(String name) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)recipeManager, recipeHolder -> recipeHolder.value() instanceof RecipeExtremeShaped && recipeHolder.id().equals((Object)ResourceLocation.tryParse((String)name))));
    }

    @ZenCodeType.Method
    public static void removeShaped(IItemStack stack) {
        ItemStack itemStack = stack.getInternal();
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)recipeManager, recipeHolder -> recipeHolder.value() instanceof RecipeExtremeShaped && ((RecipeExtremeCrafting)recipeHolder.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem() == itemStack.getItem()));
    }

    @ZenCodeType.Method
    public static void removeShapeless(String name) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)recipeManager, recipeHolder -> recipeHolder.value() instanceof RecipeExtremeShapeless && recipeHolder.id().equals((Object)ResourceLocation.tryParse((String)name))));
    }

    @ZenCodeType.Method
    public static void removeShapeless(IItemStack stack) {
        ItemStack itemStack = stack.getInternal();
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)recipeManager, recipeHolder -> recipeHolder.value() instanceof RecipeExtremeShapeless && ((RecipeExtremeCrafting)recipeHolder.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem() == itemStack.getItem()));
    }
}

