/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.event.AvaritiaClientEvent;
import net.byAqua3.avaritia.loader.AvaritiaConfigs;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ItemInfinityArmor
extends ArmorItem {
    public ItemInfinityArmor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (this.getEquipmentSlot() == EquipmentSlot.FEET) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.literal((String)(ChatFormatting.BLUE.toString() + "+" + AvaritiaClientEvent.makeSANIC("SANIC").getString() + ChatFormatting.BLUE.toString() + "% Speed")));
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.getEquipmentSlot() == EquipmentSlot.HEAD && slotId == 39) {
                player.setAirSupply(300);
                player.getFoodData().setFoodLevel(20);
                player.getFoodData().setSaturation(20.0f);
                if (((Boolean)AvaritiaConfigs.nightVision.get()).booleanValue()) {
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 300, 0, false, false));
                }
            } else if (this.getEquipmentSlot() == EquipmentSlot.CHEST && slotId == 38) {
                player.setArrowCount(0);
                player.getAbilities().mayfly = true;
                player.getAbilities().setFlyingSpeed(0.1f);
                if (((Boolean)AvaritiaConfigs.clearBadEffect.get()).booleanValue()) {
                    ArrayList mobEffects = Lists.newArrayList((Iterable)player.getActiveEffects());
                    for (MobEffectInstance mobEffect : mobEffects) {
                        if (((MobEffect)mobEffect.getEffect().value()).isBeneficial()) continue;
                        player.removeEffect(mobEffect.getEffect());
                    }
                }
                stack.update((DataComponentType)AvaritiaDataComponents.FLY.get(), (Object)false, fly -> player.getAbilities().flying);
            } else if (this.getEquipmentSlot() == EquipmentSlot.LEGS && slotId == 37) {
                if (((Boolean)AvaritiaConfigs.clearFire.get()).booleanValue()) {
                    player.clearFire();
                }
            } else if (this.getEquipmentSlot() == EquipmentSlot.FEET && slotId == 36) {
                if (((Boolean)AvaritiaConfigs.stepHeight.get()).booleanValue()) {
                    player.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(1.0625);
                }
                if (((Boolean)AvaritiaConfigs.speed.get()).booleanValue()) {
                    boolean flying = player.getAbilities().flying;
                    boolean swimming = player.isInWater();
                    if (player.onGround() || flying || swimming) {
                        boolean sneaking = player.isCrouching();
                        float speed = (float)((double)0.15f * (Double)AvaritiaConfigs.speedValue.get()) * (flying ? 1.1f : 1.0f) * (swimming ? 1.2f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                        if (player.zza > 0.0f) {
                            player.moveRelative(speed, new Vec3(0.0, 0.0, 1.0));
                        } else if (player.zza < 0.0f) {
                            player.moveRelative(-speed * 0.25f, new Vec3(0.0, 0.0, 1.0));
                        }
                        if (player.xxa != 0.0f) {
                            player.moveRelative(speed * 0.5f * Math.signum(player.xxa), new Vec3(1.0, 0.0, 0.0));
                        }
                    }
                }
            }
        }
    }
}

