/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.byAqua3.avaritia.inventory.ContainerExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeCollector;
import net.byAqua3.avaritia.recipe.RecipeCompressor;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeExtremeShaped;
import net.byAqua3.avaritia.recipe.RecipeExtremeShapeless;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;

public class RecipeUtils {
    public static List<RecipeExtremeCrafting> getExtremeCraftingRecipes(List<RecipeHolder<?>> recipes) {
        ArrayList<RecipeExtremeCrafting> recipeList = new ArrayList<RecipeExtremeCrafting>();
        for (RecipeHolder<?> recipeHolder : recipes) {
            Recipe recipe = recipeHolder.value();
            if (!(recipe instanceof RecipeExtremeShaped) && !(recipe instanceof RecipeExtremeShapeless)) continue;
            RecipeExtremeCrafting recipeExtremeCrafting = (RecipeExtremeCrafting)recipe;
            recipeList.add(recipeExtremeCrafting);
        }
        recipeList.sort(new Comparator<RecipeExtremeCrafting>(){

            @Override
            public int compare(RecipeExtremeCrafting recipe1, RecipeExtremeCrafting recipe2) {
                int itemId1 = BuiltInRegistries.ITEM.getId((Object)recipe1.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem());
                int itemId2 = BuiltInRegistries.ITEM.getId((Object)recipe2.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem());
                return Integer.valueOf(itemId1).compareTo(itemId2);
            }
        });
        return recipeList;
    }

    public static List<RecipeExtremeCrafting> getExtremeCraftingRecipes(RecipeManager recipeManager) {
        return RecipeUtils.getExtremeCraftingRecipes(new ArrayList(recipeManager.getRecipes()));
    }

    public static List<RecipeExtremeCrafting> getExtremeCraftingRecipes(Level level) {
        return RecipeUtils.getExtremeCraftingRecipes(level.getRecipeManager());
    }

    public static List<RecipeCompressor> getCompressorRecipes(List<RecipeHolder<?>> recipes) {
        ArrayList<RecipeCompressor> recipeList = new ArrayList<RecipeCompressor>();
        for (RecipeHolder<?> recipeHolder : recipes) {
            RecipeCompressor recipeCompressor;
            Recipe recipe = recipeHolder.value();
            if (!(recipe instanceof RecipeCompressor) || (recipeCompressor = (RecipeCompressor)recipe).getIngredients().isEmpty()) continue;
            recipeList.add(recipeCompressor);
        }
        recipeList.sort(new Comparator<RecipeCompressor>(){

            @Override
            public int compare(RecipeCompressor recipe1, RecipeCompressor recipe2) {
                int itemId1 = BuiltInRegistries.ITEM.getId((Object)recipe1.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem());
                int itemId2 = BuiltInRegistries.ITEM.getId((Object)recipe2.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getItem());
                return Integer.valueOf(itemId1).compareTo(itemId2);
            }
        });
        return recipeList;
    }

    public static List<RecipeCompressor> getCompressorRecipes(RecipeManager recipeManager) {
        return RecipeUtils.getCompressorRecipes(new ArrayList(recipeManager.getRecipes()));
    }

    public static List<RecipeCompressor> getCompressorRecipes(Level level) {
        return RecipeUtils.getCompressorRecipes(level.getRecipeManager());
    }

    public static RecipeCompressor getCompressorRecipe(List<RecipeHolder<?>> recipes, ItemStack input) {
        SimpleContainer matrix = new SimpleContainer(1);
        matrix.addItem(input);
        ContainerExtremeCrafting crafting = new ContainerExtremeCrafting(null, 1, 1, matrix);
        for (RecipeHolder<?> recipeHolder : recipes) {
            RecipeCompressor recipeCompressor;
            Recipe recipe = recipeHolder.value();
            if (!(recipe instanceof RecipeCompressor) || !(recipeCompressor = (RecipeCompressor)recipe).matches(crafting.asCraftInput(), null)) continue;
            return recipeCompressor;
        }
        return null;
    }

    public static RecipeCompressor getCompressorRecipe(RecipeManager recipeManager, ItemStack input) {
        return RecipeUtils.getCompressorRecipe(new ArrayList(recipeManager.getRecipes()), input);
    }

    public static RecipeCompressor getCompressorRecipe(Level level, ItemStack input) {
        return RecipeUtils.getCompressorRecipe(level.getRecipeManager(), input);
    }

    public static RecipeCompressor getCompressorRecipeFromResult(List<RecipeHolder<?>> recipes, ItemStack result) {
        for (RecipeHolder<?> recipeHolder : recipes) {
            RecipeCompressor recipeCompressor;
            Recipe recipe = recipeHolder.value();
            if (!(recipe instanceof RecipeCompressor) || !ItemStack.isSameItemSameComponents((ItemStack)(recipeCompressor = (RecipeCompressor)recipe).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), (ItemStack)result)) continue;
            return recipeCompressor;
        }
        return null;
    }

    public static RecipeCompressor getCompressorRecipeFromResult(RecipeManager recipeManager, ItemStack result) {
        return RecipeUtils.getCompressorRecipeFromResult(new ArrayList(recipeManager.getRecipes()), result);
    }

    public static RecipeCompressor getCompressorRecipeFromResult(Level level, ItemStack result) {
        return RecipeUtils.getCompressorRecipeFromResult(level.getRecipeManager(), result);
    }

    public static RecipeCompressor getCompressorRecipeFromResult(List<RecipeHolder<?>> recipes, ItemStack result, DataComponentType<?> dataComponentType) {
        for (RecipeHolder<?> recipeHolder : recipes) {
            RecipeCompressor recipeCompressor;
            ItemStack itemStack;
            Recipe recipe = recipeHolder.value();
            if (!(recipe instanceof RecipeCompressor) || !ItemStack.isSameItem((ItemStack)(itemStack = (recipeCompressor = (RecipeCompressor)recipe).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)), (ItemStack)result) || !itemStack.has(dataComponentType) || !result.has(dataComponentType) || !itemStack.get(dataComponentType).equals(result.get(dataComponentType))) continue;
            return recipeCompressor;
        }
        return null;
    }

    public static RecipeCompressor getCompressorRecipeFromResult(RecipeManager recipeManager, ItemStack result, DataComponentType<?> dataComponentType) {
        return RecipeUtils.getCompressorRecipeFromResult(new ArrayList(recipeManager.getRecipes()), result, dataComponentType);
    }

    public static RecipeCompressor getCompressorRecipeFromResult(Level level, ItemStack result, DataComponentType<?> dataComponentType) {
        return RecipeUtils.getCompressorRecipeFromResult(level.getRecipeManager(), result, dataComponentType);
    }

    public static List<RecipeCollector> getCollectorRecipes() {
        ArrayList<RecipeCollector> recipeList = new ArrayList<RecipeCollector>();
        recipeList.add(new RecipeCollector());
        return recipeList;
    }

    public static ResourceLocation getRecipeId(List<RecipeHolder<?>> recipes, Recipe<?> recipe) {
        for (RecipeHolder<?> recipeHolder : recipes) {
            if (!recipe.equals((Object)recipeHolder.value())) continue;
            return recipeHolder.id();
        }
        return null;
    }

    public static ResourceLocation getRecipeId(RecipeManager recipeManager, Recipe<?> recipe) {
        return RecipeUtils.getRecipeId(new ArrayList(recipeManager.getRecipes()), recipe);
    }

    public static ResourceLocation getRecipeId(Level level, Recipe<?> recipe) {
        return RecipeUtils.getRecipeId(level.getRecipeManager(), recipe);
    }
}

