/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.compat.rei;

import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.byAqua3.avaritia.compat.rei.category.CategoryCollectorRecipe;
import net.byAqua3.avaritia.compat.rei.category.CategoryCompressorRecipe;
import net.byAqua3.avaritia.compat.rei.category.CategoryExtremeRecipe;
import net.byAqua3.avaritia.compat.rei.display.DisplayCollectorRecipe;
import net.byAqua3.avaritia.compat.rei.display.DisplayCompressorRecipe;
import net.byAqua3.avaritia.compat.rei.display.DisplayExtremeRecipe;
import net.byAqua3.avaritia.compat.rei.transfer.TransferHandlerExtremeRecipe;
import net.byAqua3.avaritia.gui.GuiExtremeCraftingTable;
import net.byAqua3.avaritia.gui.GuiNeutroniumCompressor;
import net.byAqua3.avaritia.inventory.MenuExtremeCrafting;
import net.byAqua3.avaritia.inventory.MenuNeutroniumCompressor;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.recipe.RecipeCollector;
import net.byAqua3.avaritia.recipe.RecipeCompressor;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.util.AvaritiaRecipeUtils;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class AvaritiaREIPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<DisplayExtremeRecipe> EXTREME_CRAFTING = CategoryIdentifier.of((String)"avaritia", (String)"extreme_crafting");
    public static final CategoryIdentifier<DisplayCompressorRecipe> COMPRESSOR = CategoryIdentifier.of((String)"avaritia", (String)"compressor");
    public static final CategoryIdentifier<DisplayCollectorRecipe> COLLECTOR = CategoryIdentifier.of((String)"avaritia", (String)"collector");

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new CategoryExtremeRecipe());
        registry.add((DisplayCategory)new CategoryCompressorRecipe());
        registry.add((DisplayCategory)new CategoryCollectorRecipe());
        registry.addWorkstations(CategoryIdentifier.of((String)"minecraft", (String)"plugins/crafting"), new EntryStack[]{EntryStacks.of((class_1935)AvaritiaBlocks.COMPRESSED_CRAFTING_TABLE_ITEM)});
        registry.addWorkstations(CategoryIdentifier.of((String)"minecraft", (String)"plugins/crafting"), new EntryStack[]{EntryStacks.of((class_1935)AvaritiaBlocks.DOUBLE_COMPRESSED_CRAFTING_TABLE_ITEM)});
        registry.addWorkstations(EXTREME_CRAFTING, new EntryStack[]{EntryStacks.of((class_1935)AvaritiaBlocks.EXTREME_CRAFTING_TABLE_ITEM)});
        registry.addWorkstations(COMPRESSOR, new EntryStack[]{EntryStacks.of((class_1935)AvaritiaBlocks.COMPRESSOR_ITEM)});
        registry.addWorkstations(COLLECTOR, new EntryStack[]{EntryStacks.of((class_1935)AvaritiaBlocks.NEUTRON_COLLECTOR_ITEM)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        for (RecipeExtremeCrafting recipeExtremeCrafting : AvaritiaRecipeUtils.getExtremeCraftingRecipes((class_1937)level)) {
            registry.add((Display)new DisplayExtremeRecipe(recipeExtremeCrafting));
        }
        for (RecipeCompressor recipeCompressor : AvaritiaRecipeUtils.getCompressorRecipes((class_1937)level)) {
            registry.add((Display)new DisplayCompressorRecipe(recipeCompressor));
        }
        for (RecipeCollector recipeCollector : AvaritiaRecipeUtils.getCollectorRecipes((class_1937)level)) {
            registry.add((Display)new DisplayCollectorRecipe(recipeCollector));
        }
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register((TransferHandler)TransferHandlerExtremeRecipe.create(MenuExtremeCrafting.class, EXTREME_CRAFTING, new SimpleTransferHandler.IntRange(1, 82)));
        registry.register((TransferHandler)SimpleTransferHandler.create(MenuNeutroniumCompressor.class, COMPRESSOR, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerContainerClickArea(new Rectangle(175, 79, 28, 26), GuiExtremeCraftingTable.class, new CategoryIdentifier[]{EXTREME_CRAFTING});
        registry.registerContainerClickArea(new Rectangle(62, 35, 22, 15), GuiNeutroniumCompressor.class, new CategoryIdentifier[]{COMPRESSOR});
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        rule.hide(List.of(EntryStacks.of((class_1935)AvaritiaItems.MATTER_CLUSTER)));
    }
}

