/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.component;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;
import net.byAqua3.avaritia.tile.TileInfinityChest;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class ClusterContainerContents {
    private static final int NO_SLOT = -1;
    private static final int MAX_SIZE = Integer.MAX_VALUE;
    public static final ClusterContainerContents EMPTY = new ClusterContainerContents((class_2371<class_1799>)class_2371.method_10211());
    public static final Codec<ClusterContainerContents> CODEC = Slot.CODEC.sizeLimitedListOf(Integer.MAX_VALUE).xmap(ClusterContainerContents::fromSlots, ClusterContainerContents::asSlots);
    public static final class_9139<class_9129, ClusterContainerContents> STREAM_CODEC = class_1799.field_49268.method_56433(class_9135.method_58000((int)Integer.MAX_VALUE)).method_56432(ClusterContainerContents::new, instance -> instance.items);
    private final class_2371<class_1799> items;
    private final int hashCode;

    private ClusterContainerContents(class_2371<class_1799> items) {
        if (items.size() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Got " + items.size() + " items, but maximum is " + String.valueOf(Integer.MAX_VALUE));
        }
        this.items = items;
        this.hashCode = class_1799.method_57361(items);
    }

    private ClusterContainerContents(int size) {
        this((class_2371<class_1799>)class_2371.method_10213((int)size, (Object)class_1799.field_8037));
    }

    private ClusterContainerContents(List<class_1799> items) {
        this(items.size());
        for (int i = 0; i < items.size(); ++i) {
            this.items.set(i, (Object)items.get(i));
        }
    }

    private static ClusterContainerContents fromSlots(List<Slot> slots) {
        OptionalInt optionalint = slots.stream().mapToInt(Slot::index).max();
        if (optionalint.isEmpty()) {
            return EMPTY;
        }
        ClusterContainerContents itemcontainercontents = new ClusterContainerContents(optionalint.getAsInt() + 1);
        for (Slot itemcontainercontents$slot : slots) {
            itemcontainercontents.items.set(itemcontainercontents$slot.index(), (Object)itemcontainercontents$slot.item());
        }
        return itemcontainercontents;
    }

    public static ClusterContainerContents fromItems(List<class_1799> items) {
        int i = ClusterContainerContents.findLastNonEmptySlot(items);
        if (i == -1) {
            return EMPTY;
        }
        ClusterContainerContents itemcontainercontents = new ClusterContainerContents(i + 1);
        for (int j = 0; j <= i; ++j) {
            itemcontainercontents.items.set(j, (Object)items.get(j).method_7972());
        }
        return itemcontainercontents;
    }

    private static int findLastNonEmptySlot(List<class_1799> items) {
        for (int i = items.size() - 1; i >= 0; --i) {
            if (items.get(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    private List<Slot> asSlots() {
        ArrayList<Slot> list = new ArrayList<Slot>();
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 itemStack = (class_1799)this.items.get(i);
            if (itemStack.method_7960()) continue;
            list.add(new Slot(i, itemStack));
        }
        return list;
    }

    public void copyInto(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            class_1799 itemStack = i < this.items.size() ? (class_1799)this.items.get(i) : class_1799.field_8037;
            list.set(i, (Object)itemStack.method_7972());
        }
    }

    public class_1799 copyOne() {
        return this.items.isEmpty() ? class_1799.field_8037 : ((class_1799)this.items.get(0)).method_7972();
    }

    public Stream<class_1799> stream() {
        return this.items.stream().map(class_1799::method_7972);
    }

    public Stream<class_1799> nonEmptyStream() {
        return this.items.stream().filter(itemStack -> !itemStack.method_7960()).map(class_1799::method_7972);
    }

    public Iterable<class_1799> nonEmptyItems() {
        return Iterables.filter(this.items, itemStack -> !itemStack.method_7960());
    }

    public Iterable<class_1799> nonEmptyItemsCopy() {
        return Iterables.transform(this.nonEmptyItems(), class_1799::method_7972);
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof ClusterContainerContents) {
            ClusterContainerContents itemcontainercontents = (ClusterContainerContents)pOther;
            if (class_1799.method_57362(this.items, itemcontainercontents.items)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int getSlots() {
        return this.items.size();
    }

    public class_1799 getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return ((class_1799)this.items.get(slot)).method_7972();
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new UnsupportedOperationException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    record Slot(int index, class_1799 item) {
        public static final Codec<Slot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)0x7FFFFFFE).fieldOf("slot").forGetter(Slot::index), (App)TileInfinityChest.CODEC.fieldOf("item").forGetter(Slot::item)).apply((Applicative)instance, Slot::new));
    }
}

