/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.byAqua3.avaritia.entity.EntityEndestPearl;
import net.byAqua3.avaritia.loader.AvaritiaEntities;
import net.byAqua3.avaritia.loader.AvaritiaSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4770;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class EntityGapingVoid
extends class_1297 {
    private static final class_2940<Integer> AGE = class_2945.method_12791(EntityGapingVoid.class, (class_2941)class_2943.field_13327);
    public static final int MAX_LIFETIME = 186;
    public static final double COLLAPSE = 0.95;
    private static final int SUCK_RANGE = 20;
    private class_1657 player;

    public EntityGapingVoid(class_1299<? extends EntityGapingVoid> entityType, class_1937 level) {
        super(entityType, level);
    }

    public EntityGapingVoid(class_1937 level) {
        this(AvaritiaEntities.GAPING_VOID, level);
    }

    public int getAge() {
        return (Integer)this.field_6011.method_12789(AGE);
    }

    public void setAge(int age) {
        this.field_6011.method_12778(AGE, (Object)age);
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    public void setPlayer(class_1657 player) {
        this.player = player;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(AGE, (Object)0);
    }

    protected void method_5749(class_2487 tag) {
        this.setAge(tag.method_10550("age"));
    }

    protected void method_5652(class_2487 tag) {
        tag.method_10569("age", this.getAge());
    }

    public boolean method_5640(double distance) {
        double d0 = 1.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 64.0 * class_1297.method_5824()) * d0;
    }

    private static double ease(double in) {
        double t = in - 1.0;
        return Math.sqrt(1.0 - t * t);
    }

    public static double getVoidScale(double age) {
        double life = age / 186.0;
        double curve = life < 0.95 ? 0.005 + EntityGapingVoid.ease(1.0 - (0.95 - life) / 0.95) * 0.995 : EntityGapingVoid.ease(1.0 - (life - 0.95) / 0.050000000000000044);
        return 10.0 * curve;
    }

    private boolean shouldSuck(class_1297 entity) {
        if (entity instanceof EntityEndestPearl) {
            return false;
        }
        if (entity instanceof EntityGapingVoid) {
            return false;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return !player.method_7337();
        }
        return true;
    }

    private boolean shouldAttack(class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return false;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return !player.method_7337();
        }
        return true;
    }

    public void method_5773() {
        super.method_5773();
        int age = this.getAge();
        if (age == 0) {
            this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), AvaritiaSounds.GAPING_VOID, class_3419.field_15251, 8.0f, 1.0f, true);
        }
        this.setAge(age + 1);
        class_243 pos = this.method_19538();
        double voidScale = EntityGapingVoid.getVoidScale(age);
        for (int i = 0; i < 50; ++i) {
            this.method_37908().method_8406((class_2394)class_2398.field_11214, this.method_23317(), this.method_23318(), this.method_23321(), this.field_5974.method_43059() * 3.0, this.field_5974.method_43059() * 3.0, this.field_5974.method_43059() * 3.0);
        }
        double radius = voidScale * 0.5;
        class_238 aabb = class_238.method_54784((class_2338)this.method_24515().method_10081(new class_2382(-20, -20, -20)), (class_2338)this.method_24515().method_10081(new class_2382(20, 20, 20)));
        List entities = this.method_37908().method_8390(class_1297.class, aabb, this::shouldSuck);
        for (class_1297 entity : entities) {
            if (entity == this) continue;
            double posX = pos.field_1352 - entity.method_23317();
            double posY = pos.field_1351 - entity.method_23318();
            double posZ = pos.field_1350 - entity.method_23321();
            double len = Math.sqrt(posX * posX + posY * posY + posZ * posZ);
            double lenn = len / 20.0;
            if (!(len <= 20.0)) continue;
            double strength = (1.0 - lenn) * (1.0 - lenn);
            double power = 0.075 * radius;
            if (entity instanceof class_1528) {
                power *= 100.0;
            }
            class_243 motion = entity.method_18798();
            double motionX = motion.field_1352 + posX / len * strength * power;
            double motionY = motion.field_1351 + posY / len * strength * power;
            double motionZ = motion.field_1350 + posZ / len * strength * power;
            entity.method_18800(motionX, motionY, motionZ);
        }
        int attackRange = (int)(radius * 0.95);
        aabb = class_238.method_54784((class_2338)this.method_24515().method_10081(new class_2382(-attackRange, -attackRange, -attackRange)), (class_2338)this.method_24515().method_10081(new class_2382(attackRange, attackRange, attackRange)));
        List entitiesToAttack = this.method_37908().method_8390(class_1309.class, aabb, this::shouldAttack);
        for (class_1297 toAttack : entitiesToAttack) {
            double posZ;
            double posY;
            double posX;
            double len;
            if (toAttack == this || !((len = Math.sqrt((posX = pos.field_1352 - toAttack.method_23317()) * posX + (posY = pos.field_1351 - toAttack.method_23318()) * posY + (posZ = pos.field_1350 - toAttack.method_23321()) * posZ)) <= (double)attackRange)) continue;
            if (toAttack instanceof class_1560 || toAttack instanceof class_1510) {
                toAttack.method_5643(this.method_48923().method_48802(this.player), 10.0f);
                continue;
            }
            if (toAttack instanceof class_1528) {
                toAttack.method_5643(this.method_48923().method_48829(), 20.0f);
                continue;
            }
            toAttack.method_5643(this.method_48923().method_48829(), 10.0f);
        }
        attackRange = (int)((double)attackRange + 2.0);
        if (age % 10 == 0) {
            class_243 pos1 = pos;
            int blockRange = Math.round(attackRange);
            for (int y = -blockRange; y <= blockRange; ++y) {
                for (int z = -blockRange; z <= blockRange; ++z) {
                    for (int x = -blockRange; x <= blockRange; ++x) {
                        float resist;
                        class_243 pos2 = new class_243((double)x, (double)y, (double)z);
                        class_243 rPos = pos1.method_1019(pos2);
                        class_2338 blockPos = new class_2338((int)Math.floor(rPos.field_1352), (int)Math.floor(rPos.field_1351), (int)Math.floor(rPos.field_1350));
                        class_2680 blockState = this.method_37908().method_8320(blockPos);
                        class_2248 block = blockState.method_26204();
                        double dist = Math.sqrt(pos2.field_1352 * pos2.field_1352 + pos2.field_1351 * pos2.field_1351 + pos2.field_1350 * pos2.field_1350);
                        if (!(dist <= (double)attackRange) || blockState.method_26215() || !((resist = block.method_9520()) <= 10.0f)) continue;
                        if (!this.method_37908().method_8608()) {
                            Random random = new Random();
                            ArrayList<class_1799> drops = new ArrayList<class_1799>();
                            List blockDrops = class_2248.method_9562((class_2680)blockState, (class_3218)((class_3218)this.method_37908()), (class_2338)blockPos, null);
                            if (!blockDrops.isEmpty()) {
                                drops.addAll(blockDrops);
                            } else {
                                class_2960 blockKey = class_7923.field_41175.method_10221((Object)block);
                                class_1792 blockItem = (class_1792)class_7923.field_41178.method_10223(blockKey);
                                drops.add(new class_1799((class_1935)blockItem));
                            }
                            if (!drops.isEmpty() && random.nextInt(100) + 1 <= 90) {
                                for (class_1799 itemStack : drops) {
                                    class_1542 itemEntity = new class_1542(this.method_37908(), (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), itemStack);
                                    itemEntity.method_6988();
                                    this.method_37908().method_8649((class_1297)itemEntity);
                                }
                            }
                        }
                        if (!(block instanceof class_4770)) {
                            this.method_37908().method_20290(2001, blockPos, class_2248.method_9507((class_2680)blockState));
                        }
                        this.method_37908().method_8501(blockPos, class_2246.field_10124.method_9564());
                        this.method_37908().method_43276((class_6880)class_5712.field_28165, blockPos, class_5712.class_7397.method_43286((class_1297)this.player, (class_2680)blockState));
                    }
                }
            }
        }
        if (age >= 186) {
            this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 6.0f, false, class_1937.class_7867.field_40889);
            this.setAge(0);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }
}

