/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.byAqua3.avaritia.damage.DamageSourceInfinity;
import net.byAqua3.avaritia.event.callback.EntityJoinLevelEvent;
import net.byAqua3.avaritia.event.callback.EntityTickEvent;
import net.byAqua3.avaritia.event.callback.ItemEntityPickupEvent;
import net.byAqua3.avaritia.event.callback.LivingDropsEvent;
import net.byAqua3.avaritia.event.callback.LivingJumpEvent;
import net.byAqua3.avaritia.event.callback.OnDatapackSyncEvent;
import net.byAqua3.avaritia.gui.criterion.CriterionAvaritiaRoot;
import net.byAqua3.avaritia.item.ItemInfinityAxe;
import net.byAqua3.avaritia.item.ItemInfinityPickaxe;
import net.byAqua3.avaritia.item.ItemInfinityShovel;
import net.byAqua3.avaritia.item.ItemInfinitySword;
import net.byAqua3.avaritia.item.ItemMatterCluster;
import net.byAqua3.avaritia.item.ItemSingularity;
import net.byAqua3.avaritia.item.ItemSkullFireSword;
import net.byAqua3.avaritia.loader.AvaritiaBlockTags;
import net.byAqua3.avaritia.loader.AvaritiaConfigs;
import net.byAqua3.avaritia.loader.AvaritiaCriterions;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.loader.AvaritiaSingularities;
import net.byAqua3.avaritia.network.PacketSingularitySync;
import net.byAqua3.avaritia.singularity.Singularity;
import net.byAqua3.avaritia.util.AvaritiaItemUtils;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1547;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class AvaritiaEvent {
    public static final List<class_1792> FAST_ITEMS = Arrays.asList(AvaritiaItems.INFINITY_SWORD, AvaritiaItems.INFINITY_BOW, AvaritiaItems.INFINITY_AXE, AvaritiaItems.INFINITY_PICKAXE, AvaritiaItems.INFINITY_SHOVEL, AvaritiaItems.INFINITY_HOE, AvaritiaItems.INFINITY_HELMET, AvaritiaItems.INFINITY_CHESTPLATE, AvaritiaItems.INFINITY_LEGGINGS, AvaritiaItems.INFINITY_BOOTS);
    public static final List<class_1792> IMMORTAL_ITEMS = Arrays.asList(AvaritiaItems.INFINITY_SWORD, AvaritiaItems.INFINITY_BOW, AvaritiaItems.INFINITY_AXE, AvaritiaItems.INFINITY_PICKAXE, AvaritiaItems.INFINITY_SHOVEL, AvaritiaItems.INFINITY_HOE, AvaritiaItems.INFINITY_HELMET, AvaritiaItems.INFINITY_CHESTPLATE, AvaritiaItems.INFINITY_LEGGINGS, AvaritiaItems.INFINITY_BOOTS, AvaritiaItems.NEUTRON_PILE, AvaritiaItems.NEUTRON_NUGGET, AvaritiaItems.NETRONIUM_INGOT, AvaritiaItems.INFINITY_CATALYST, AvaritiaItems.INFINITY_INGOT);
    public static boolean ClientFly;
    public static boolean ClientMove;
    public static List<String> FlyPlayer;
    public static List<String> MovePlayer;

    public AvaritiaEvent() {
        this.onEntityJoinLevelEvent();
        this.onAttackEntityEvent();
        this.onAttackBlockEvent();
        this.onPlayerBlockBreakBeforeEvent();
        this.onLivingTickEvent();
        this.onLivingDropsEvent();
        this.onLivingJumpEvent();
        this.onLivingDamageEvent();
        this.onLivingDeathEvent();
        this.onItemEntityPickupEvent();
        this.OnDatapackSyncEvent();
    }

    public void onEntityJoinLevelEvent() {
        EntityJoinLevelEvent.EVENT.register((entity, level, existing) -> {
            if (entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                class_1799 itemStack = itemEntity.method_6983();
                class_1792 item = itemStack.method_7909();
                if (FAST_ITEMS.contains(item)) {
                    itemEntity.method_6982(8);
                }
                if (IMMORTAL_ITEMS.contains(item) || item instanceof ItemSingularity) {
                    itemEntity.method_5684(true);
                }
            }
            return true;
        });
    }

    public void onAttackEntityEvent() {
        AttackEntityCallback.EVENT.register((player, level, hand, entity, hitResult) -> {
            class_1799 itemStack = player.method_5998(hand);
            class_1792 item = itemStack.method_7909();
            if (item instanceof ItemInfinitySword) {
                ((ItemInfinitySword)item).onLeftClickEntity(itemStack, player, entity);
            } else if (entity instanceof class_1657 && AvaritiaItemUtils.isInfinityArmor((class_1657)entity)) {
                ((class_1657)entity).field_6235 = 0;
                ((class_1657)entity).field_6213 = 0;
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    public void onAttackBlockEvent() {
        AttackBlockCallback.EVENT.register((player, level, hand, pos, direction) -> {
            class_2680 blockState = level.method_8320(pos);
            class_2248 block = blockState.method_26204();
            class_1799 itemStack = player.method_5998(hand);
            class_1792 item = itemStack.method_7909();
            if ((item instanceof ItemInfinityAxe || item instanceof ItemInfinityShovel) && player.method_7337()) {
                item.method_7879(itemStack, level, blockState, pos, (class_1309)player);
            }
            if (item instanceof ItemInfinityPickaxe) {
                List blockDrops;
                if (itemStack.method_57826(AvaritiaDataComponents.HAMMER) && ((Boolean)itemStack.method_57825(AvaritiaDataComponents.HAMMER, (Object)false)).booleanValue()) {
                    if (player.method_7337() || blockState.method_26214((class_1922)level, pos) <= -1.0f) {
                        item.method_7879(itemStack, level, blockState, pos, (class_1309)player);
                    }
                } else if (!level.method_8608() && !player.method_7337() && (blockDrops = class_2248.method_9562((class_2680)blockState, (class_3218)((class_3218)level), (class_2338)pos, null)).isEmpty()) {
                    class_2960 blockKey = class_7923.field_41175.method_10221((Object)block);
                    class_1792 blockItem = (class_1792)class_7923.field_41178.method_10223(blockKey);
                    class_1542 itemEntity = new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), new class_1799((class_1935)blockItem));
                    itemEntity.method_6988();
                    level.method_8649((class_1297)itemEntity);
                    level.method_22352(pos, false);
                }
            }
            return class_1269.field_5811;
        });
    }

    public void onPlayerBlockBreakBeforeEvent() {
        PlayerBlockBreakEvents.BEFORE.register((level, player, pos, state, blockEntity) -> {
            class_1799 itemStack = player.method_6047();
            class_1792 item = itemStack.method_7909();
            List tags = state.method_40144().toList();
            if (item instanceof ItemInfinityPickaxe) {
                if (itemStack.method_57826(AvaritiaDataComponents.HAMMER) && ((Boolean)itemStack.method_57825(AvaritiaDataComponents.HAMMER, (Object)false)).booleanValue()) {
                    item.method_7879(itemStack, level, state, pos, (class_1309)player);
                    return false;
                }
            } else if (item instanceof ItemInfinityShovel && itemStack.method_57826(AvaritiaDataComponents.DESTROYER) && ((Boolean)itemStack.method_57825(AvaritiaDataComponents.DESTROYER, (Object)false)).booleanValue() && tags.contains(AvaritiaBlockTags.INFINITY_SHOVEL)) {
                item.method_7879(itemStack, level, state, pos, (class_1309)player);
                return false;
            }
            return true;
        });
    }

    public void onLivingTickEvent() {
        EntityTickEvent.POST_EVENT.register(entity -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                String playerName = player.method_5476().getString();
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    ((CriterionAvaritiaRoot)AvaritiaCriterions.ROOT).trigger(serverPlayer);
                }
                if ((ClientFly || FlyPlayer.contains(playerName)) && player.method_6118(class_1304.field_6174).method_7909() != AvaritiaItems.INFINITY_CHESTPLATE) {
                    if (!player.method_7337()) {
                        player.method_31549().field_7478 = false;
                        player.method_31549().field_7479 = false;
                    }
                    player.method_31549().method_7248(0.05f);
                    if (player.method_37908().method_8608() && ClientFly) {
                        ClientFly = false;
                    }
                    if (FlyPlayer.contains(playerName)) {
                        FlyPlayer.remove(playerName);
                    }
                }
                if ((ClientMove || MovePlayer.contains(playerName)) && player.method_6118(class_1304.field_6166).method_7909() != AvaritiaItems.INFINITY_BOOTS) {
                    player.method_5996(class_5134.field_47761).method_6192(0.5);
                    if (player.method_37908().method_8608() && ClientMove) {
                        ClientMove = false;
                    }
                    if (MovePlayer.contains(playerName)) {
                        MovePlayer.remove(playerName);
                    }
                }
                if (player.method_6118(class_1304.field_6174).method_7909() == AvaritiaItems.INFINITY_CHESTPLATE) {
                    if (player.method_37908().method_8608()) {
                        ClientFly = true;
                    }
                    if (!FlyPlayer.contains(playerName)) {
                        FlyPlayer.add(playerName);
                    }
                }
                if (player.method_6118(class_1304.field_6166).method_7909() == AvaritiaItems.INFINITY_BOOTS) {
                    boolean flying = player.method_31549().field_7479;
                    boolean swimming = player.method_5799();
                    if (player.method_24828() || flying || swimming) {
                        boolean sneaking = player.method_5715();
                        float speed = 0.15f * (flying ? 1.1f : 1.0f) * (swimming ? 1.2f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                        if (player.field_6250 > 0.0f) {
                            player.method_5724(speed, new class_243(0.0, 0.0, 1.0));
                        } else if (player.field_6250 < 0.0f) {
                            player.method_5724(-speed * 0.25f, new class_243(0.0, 0.0, 1.0));
                        }
                        if (player.field_6212 != 0.0f) {
                            player.method_5724(speed * 0.5f * Math.signum(player.field_6212), new class_243(1.0, 0.0, 0.0));
                        }
                    }
                    if (player.method_37908().method_8608()) {
                        ClientMove = true;
                    }
                    if (!MovePlayer.contains(playerName)) {
                        MovePlayer.add(playerName);
                    }
                }
            }
        });
    }

    public void onLivingDropsEvent() {
        LivingDropsEvent.EVENT.register((entity, source, drops, recentlyHit) -> {
            class_1657 player;
            if (entity instanceof class_1547 && source.method_5526() instanceof class_1657 && (player = (class_1657)source.method_5526()).method_6047().method_7909() instanceof ItemSkullFireSword) {
                for (class_1542 itemEntity : drops) {
                    if (itemEntity.method_6983().method_7909() != class_1802.field_8791) continue;
                    drops.remove(itemEntity);
                }
                int randomInt = player.method_59922().method_43048(100) + 1;
                if ((double)randomInt <= AvaritiaConfigs.DropChange.getDouble()) {
                    class_1542 itemEntity;
                    itemEntity = new class_1542(entity.method_37908(), entity.method_23317(), entity.method_23318(), entity.method_23321(), new class_1799((class_1935)class_1802.field_8791));
                    itemEntity.method_6988();
                    if (!entity.method_37908().method_8608()) {
                        entity.method_37908().method_8649((class_1297)itemEntity);
                    }
                }
            }
            return true;
        });
    }

    public void onLivingJumpEvent() {
        LivingJumpEvent.EVENT.register(entity -> {
            class_1657 player;
            if (entity instanceof class_1657 && (player = (class_1657)entity).method_6118(class_1304.field_6166).method_7909() == AvaritiaItems.INFINITY_BOOTS) {
                player.method_18800(player.method_18798().field_1352, player.method_18798().field_1351 + 0.4, player.method_18798().field_1350);
            }
        });
    }

    public void onLivingDamageEvent() {
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            class_1657 player;
            if (entity instanceof class_1657 && AvaritiaItemUtils.isInfinityArmor(player = (class_1657)entity) && !(source instanceof DamageSourceInfinity)) {
                amount = 0.0f;
                player.field_6235 = 0;
                player.field_6213 = 0;
                return false;
            }
            return true;
        });
    }

    public void onLivingDeathEvent() {
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, source, amount) -> {
            class_1657 player;
            if (entity instanceof class_1657 && AvaritiaItemUtils.isInfinityArmor(player = (class_1657)entity) && !(source instanceof DamageSourceInfinity)) {
                amount = 0.0f;
                player.field_6235 = 0;
                player.field_6213 = 0;
                player.method_6033(Math.max(20.0f, entity.method_6063()));
                return false;
            }
            return true;
        });
    }

    public void onItemEntityPickupEvent() {
        ItemEntityPickupEvent.POST_EVENT.register((player, itemEntity, stack) -> {
            class_1792 item = stack.method_7909();
            if (item instanceof ItemMatterCluster) {
                List<class_1799> stackItems = ItemMatterCluster.getClusterItems(stack);
                for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                    class_1799 newStack;
                    int index;
                    List<class_1799> matterItems;
                    class_1799 matterStack = (class_1799)player.method_31548().field_7547.get(i);
                    if (matterStack.method_7960() || !(matterStack.method_7909() instanceof ItemMatterCluster) || ItemMatterCluster.getClusterCount(matterItems = ItemMatterCluster.getClusterItems(matterStack)) >= 4096) continue;
                    int count = 4096 - ItemMatterCluster.getClusterCount(matterItems);
                    if (count >= ItemMatterCluster.getClusterCount(stackItems)) {
                        ArrayList<class_1799> newMatterItems = new ArrayList<class_1799>();
                        newMatterItems.addAll(matterItems);
                        newMatterItems.addAll(stackItems);
                        player.method_31548().field_7547.set(i, (Object)ItemMatterCluster.makeCluster(newMatterItems));
                        for (class_1799 oldMatterStack : player.method_31548().field_7547) {
                            List<class_1799> oldMatterItems;
                            int oldCount;
                            if (!(oldMatterStack.method_7909() instanceof ItemMatterCluster) || (oldCount = ItemMatterCluster.getClusterCount(oldMatterItems = ItemMatterCluster.getClusterItems(oldMatterStack))) != 0) continue;
                            oldMatterStack.method_7939(0);
                        }
                        break;
                    }
                    if (count <= 0) break;
                    ArrayList<class_1799> newStackItems = new ArrayList<class_1799>();
                    ArrayList<class_1799> newMatterItems = new ArrayList<class_1799>();
                    int size = 0;
                    for (index = 0; index < stackItems.size() && (size += (newStack = stackItems.get(index)).method_7947()) < count; ++index) {
                    }
                    int newCount = size - count;
                    class_1799 newStack2 = stackItems.get(index);
                    class_1799 copyStack = newStack2.method_7972();
                    copyStack.method_7939(copyStack.method_7947() - newCount);
                    newStack2.method_7939(newCount);
                    newMatterItems.addAll(matterItems);
                    newMatterItems.add(copyStack);
                    newMatterItems.addAll(stackItems.subList(0, index));
                    newStackItems.add(newStack2);
                    newStackItems.addAll(stackItems.subList(index + 1, stackItems.size() - 1));
                    player.method_31548().field_7547.set(i, (Object)ItemMatterCluster.makeCluster(newMatterItems));
                    break;
                }
            }
        });
    }

    public void OnDatapackSyncEvent() {
        OnDatapackSyncEvent.EVENT.register((playerList, player) -> {
            if (player == null) {
                class_3300 resourceManager = playerList.method_14561().method_34864();
                List<Singularity> singularities = AvaritiaSingularities.loadSingularities(resourceManager);
                playerList.method_14581(ServerPlayNetworking.createS2CPacket((class_8710)new PacketSingularitySync(singularities)));
            } else {
                class_3300 resourceManager = player.method_5682().method_34864();
                List<Singularity> singularities = AvaritiaSingularities.loadSingularities(resourceManager);
                ServerPlayNetworking.send((class_3222)player, (class_8710)new PacketSingularitySync(singularities));
            }
        });
    }

    static {
        FlyPlayer = new ArrayList<String>();
        MovePlayer = new ArrayList<String>();
    }
}

