/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.config.Config;
import net.fabricmc.loader.api.FabricLoader;

public class AvaritiaConfigs {
    private static final AvaritiaConfigs INSTANCE = new AvaritiaConfigs();
    private final List<Config> conifgs = new ArrayList<Config>();
    public static Config DropChange = AvaritiaConfigs.register(new Config("dropChange", "Range: 0 ~ 100", 100.0, 0.0, 100.0, true));
    public static Config NightVision = AvaritiaConfigs.register(new Config("nightVision", "", true));
    public static Config ClearBadEffect = AvaritiaConfigs.register(new Config("clearBadEffect", "", true));

    public static AvaritiaConfigs getInstance() {
        return INSTANCE;
    }

    public List<Config> getConfigs() {
        return this.conifgs;
    }

    public static Config register(Config config) {
        AvaritiaConfigs.getInstance().getConfigs().add(config);
        return config;
    }

    public static void load() throws Exception {
        File directoryFile = new File(FabricLoader.getInstance().getConfigDir().toString() + File.separator + "avaritia");
        directoryFile.mkdirs();
        File configFile = new File(directoryFile, "avaritia.json");
        if (!configFile.exists()) {
            configFile.createNewFile();
            AvaritiaConfigs.save(configFile);
        } else {
            FileReader fileReader = new FileReader(configFile, StandardCharsets.UTF_8);
            JsonObject jsonObject = JsonParser.parseReader((Reader)fileReader).getAsJsonObject();
            for (Config config : AvaritiaConfigs.getInstance().getConfigs()) {
                JsonObject configObject = jsonObject.getAsJsonObject(config.getName());
                if (config.isBoolean()) {
                    boolean value = configObject.get("value").getAsBoolean();
                    config.setBoolean(value);
                    continue;
                }
                if (!config.isNumber()) continue;
                if (config.onlyInt()) {
                    int value = configObject.get("value").getAsInt();
                    if ((double)value < config.getMin()) {
                        value = (int)config.getMin();
                    }
                    if ((double)value > config.getMax()) {
                        value = (int)config.getMax();
                    }
                    config.setDouble(value);
                    continue;
                }
                double value = configObject.get("value").getAsDouble();
                if (value < config.getMin()) {
                    value = config.getMin();
                }
                if (value > config.getMax()) {
                    value = config.getMax();
                }
                config.setDouble(value);
            }
        }
    }

    public static void save(File file) throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileWriter fileWriter = new FileWriter(file, StandardCharsets.UTF_8);
        JsonObject jsonObject = new JsonObject();
        for (Config config : AvaritiaConfigs.getInstance().getConfigs()) {
            JsonObject configObject = new JsonObject();
            configObject.addProperty("name", config.getName());
            configObject.addProperty("description", config.getDescription());
            if (config.isBoolean()) {
                configObject.addProperty("value", Boolean.valueOf(config.getBoolean()));
            } else if (config.isNumber()) {
                if (config.onlyInt()) {
                    configObject.addProperty("value", (Number)((int)config.getDouble()));
                } else {
                    configObject.addProperty("value", (Number)config.getDouble());
                }
            }
            jsonObject.add(config.getName(), (JsonElement)configObject);
        }
        gson.toJson((JsonElement)jsonObject, (Appendable)fileWriter);
        fileWriter.close();
    }

    public static void registerConfigs() {
        try {
            AvaritiaConfigs.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

