/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.byAqua3.avaritia.Avaritia;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.singularity.Singularity;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class AvaritiaSingularities {
    private static final AvaritiaSingularities INSTANCE = new AvaritiaSingularities();
    private final List<Singularity> singularities = new ArrayList<Singularity>();

    public static AvaritiaSingularities getInstance() {
        return INSTANCE;
    }

    public static List<Singularity> loadSingularities(class_3300 resourceManager) {
        Long lastTime = System.currentTimeMillis();
        ArrayList<Singularity> singularities = new ArrayList<Singularity>();
        Map map = resourceManager.method_41265("singularities", resourceLocation -> resourceLocation.method_12832().endsWith(".json"));
        for (List resources : map.values()) {
            for (class_3298 resource : resources) {
                try {
                    BufferedReader bufferedReader = resource.method_43039();
                    JsonElement jsonElement = JsonParser.parseReader((Reader)bufferedReader);
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    String id = jsonObject.get("id").getAsString();
                    int color = jsonObject.getAsJsonArray("color").get(0).getAsInt();
                    int layerColor = jsonObject.getAsJsonArray("color").get(1).getAsInt();
                    Singularity singularity = new Singularity(id, color, layerColor);
                    singularities.add(singularity);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Avaritia.LOGGER.info("Finished loading {} singularities json after {}ms", (Object)singularities.size(), (Object)(System.currentTimeMillis() - lastTime));
        return singularities;
    }

    public List<Singularity> getSingularities() {
        return this.singularities;
    }

    public Singularity getSingularity(String id) {
        for (Singularity singularity : this.singularities) {
            if (!singularity.id.equalsIgnoreCase(id)) continue;
            return singularity;
        }
        return null;
    }

    public static void registerSingularities() {
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_5321.method_29179((class_5321)class_7923.field_44687.method_30517(), (class_2960)class_2960.method_60655((String)"avaritia", (String)"avaritia"))).register(group -> {
            for (Singularity singularity : AvaritiaSingularities.getInstance().getSingularities()) {
                class_1799 itemStack = new class_1799((class_1935)AvaritiaItems.JSON_SINGULARITY);
                itemStack.method_57379(AvaritiaDataComponents.SINGULARITY_ID, (Object)singularity.getId());
                group.addBefore((class_1935)AvaritiaItems.INFINITY_SINGULARITY, new class_1799[]{itemStack});
            }
        });
    }
}

