/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.model;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import net.byAqua3.avaritia.event.AvaritiaClientEvent;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.loader.AvaritiaRenderLayers;
import net.byAqua3.avaritia.loader.AvaritiaShaders;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4896;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_572;
import net.minecraft.class_630;

public class ModelInfinityArmor
extends class_572<class_1309> {
    public static final class_2960 EYE = class_2960.method_60655((String)"avaritia", (String)"textures/models/armor/infinity_armor_eyes.png");
    public static final class_2960 WING = class_2960.method_60655((String)"avaritia", (String)"textures/models/armor/infinity_armor_wing.png");
    public static final class_2960 WING_GLOW = class_2960.method_60655((String)"avaritia", (String)"textures/models/armor/infinity_armor_wingglow.png");
    public static final class_1058 MASK = class_310.method_1551().method_1554().method_24153(class_1059.field_5275).method_4608(class_2960.method_60655((String)"avaritia", (String)"models/armor/infinity_armor_mask"));
    public static final class_1058 MASK_INV = class_310.method_1551().method_1554().method_24153(class_1059.field_5275).method_4608(class_2960.method_60655((String)"avaritia", (String)"models/armor/infinity_armor_mask_inv"));
    public static final class_1058 WING_MASK = class_310.method_1551().method_1554().method_24153(class_1059.field_5275).method_4608(class_2960.method_60655((String)"avaritia", (String)"models/armor/infinity_armor_mask_wings"));
    public final class_630 root = ModelInfinityArmor.createLayer().method_32109();
    public final class_630 bodyRoot = ModelInfinityArmor.createBodyLayer(new class_5605(1.0f)).method_32109();
    private boolean isSilm;

    public ModelInfinityArmor(class_630 root, boolean isSilm) {
        super(root);
        this.isSilm = isSilm;
    }

    public static class_5607 createLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        class_5605 cubeDeformation = new class_5605(0.0f);
        partDefinition.method_32117("left_wing", class_5606.method_32108().method_32101(0, 0).method_32098(0.0f, -11.6f, 0.0f, 0.0f, 32.0f, 32.0f, cubeDeformation), class_5603.method_32091((float)-1.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)1.2566371f, (float)0.0f));
        partDefinition.method_32117("right_wing", class_5606.method_32108().method_32101(0, 0).method_32096().method_32098(0.0f, -11.6f, 0.0f, 0.0f, 32.0f, 32.0f, cubeDeformation), class_5603.method_32091((float)1.5f, (float)0.0f, (float)2.0f, (float)0.0f, (float)-1.2566371f, (float)0.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)64);
    }

    public static class_5607 createBodyLayer(class_5605 cubDeformation) {
        class_5609 meshDefinition = class_572.method_32011((class_5605)cubDeformation, (float)0.0f);
        class_5610 partDefinition = meshDefinition.method_32111();
        partDefinition.method_32117("hat", class_5606.method_32108().method_32101(32, 0).method_32098(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubDeformation.method_32094(-0.1f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.method_32117("left_leg", class_5606.method_32108().method_32101(0, 48).method_32096().method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.method_32094(-0.6f)), class_5603.method_32090((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.method_32117("right_leg", class_5606.method_32108().method_32101(0, 48).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.method_32094(-0.6f)), class_5603.method_32090((float)-1.9f, (float)12.0f, (float)0.0f));
        partDefinition.method_32117("left_boot", class_5606.method_32108().method_32101(0, 16).method_32096().method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.method_32094(-0.1f)), class_5603.method_32090((float)1.9f, (float)12.0f, (float)0.0f));
        partDefinition.method_32117("right_boot", class_5606.method_32108().method_32101(0, 16).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubDeformation.method_32094(-0.1f)), class_5603.method_32090((float)-1.9f, (float)12.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<class_630> method_22948() {
        return ImmutableList.of((Object)this.field_3391, (Object)this.field_3401, (Object)this.field_27433, (Object)this.field_3392, (Object)this.field_3397);
    }

    public void setScale(class_630 modelPart, float scale) {
        modelPart.field_37938 = scale;
        modelPart.field_37939 = scale;
        modelPart.field_37940 = scale;
    }

    public void method_17087(class_1309 livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.method_17087(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        class_630 leftWing = this.root.method_32086("left_wing");
        leftWing.field_3654 = this.field_3391.field_3654;
        leftWing.field_3675 = this.field_3391.field_3675 + 1.2566371f;
        leftWing.field_3674 = this.field_3391.field_3674;
        class_630 rightWing = this.root.method_32086("right_wing");
        rightWing.field_3654 = this.field_3391.field_3654;
        rightWing.field_3675 = this.field_3391.field_3675 + -1.2566371f;
        rightWing.field_3674 = this.field_3391.field_3674;
        if (livingEntity instanceof class_1531) {
            class_1531 armorStand = (class_1531)livingEntity;
            this.field_3398.field_3656 = 1.0f;
            this.field_3398.field_3654 = (float)Math.PI / 180 * armorStand.method_6921().method_10256();
            this.field_3398.field_3675 = (float)Math.PI / 180 * armorStand.method_6921().method_10257();
            this.field_3398.field_3674 = (float)Math.PI / 180 * armorStand.method_6921().method_10258();
            this.field_27433.field_3654 = (float)Math.PI / 180 * armorStand.method_6930().method_10256();
            this.field_27433.field_3675 = (float)Math.PI / 180 * armorStand.method_6930().method_10257();
            this.field_27433.field_3674 = (float)Math.PI / 180 * armorStand.method_6930().method_10258();
            this.field_3401.field_3654 = (float)Math.PI / 180 * armorStand.method_6903().method_10256();
            this.field_3401.field_3675 = (float)Math.PI / 180 * armorStand.method_6903().method_10257();
            this.field_3401.field_3674 = (float)Math.PI / 180 * armorStand.method_6903().method_10258();
            this.field_3397.field_3654 = (float)Math.PI / 180 * armorStand.method_6917().method_10256();
            this.field_3397.field_3675 = (float)Math.PI / 180 * armorStand.method_6917().method_10257();
            this.field_3397.field_3674 = (float)Math.PI / 180 * armorStand.method_6917().method_10258();
            this.field_3392.field_3654 = (float)Math.PI / 180 * armorStand.method_6900().method_10256();
            this.field_3392.field_3675 = (float)Math.PI / 180 * armorStand.method_6900().method_10257();
            this.field_3392.field_3674 = (float)Math.PI / 180 * armorStand.method_6900().method_10258();
            this.field_3394.method_17138(this.field_3398);
        }
        class_630 head = this.bodyRoot.method_32086("head");
        head.method_17138(this.field_3398);
        class_630 hat = this.bodyRoot.method_32086("hat");
        hat.method_17138(this.field_3394);
        class_630 body = this.bodyRoot.method_32086("body");
        body.method_17138(this.field_3391);
        if (livingEntity instanceof class_1642) {
            class_1642 zombie = (class_1642)livingEntity;
            class_4896.method_29352((class_630)this.field_27433, (class_630)this.field_3401, (boolean)zombie.method_6510(), (float)this.field_3447, (float)ageInTicks);
        }
        class_630 leftArm = this.bodyRoot.method_32086("left_arm");
        leftArm.method_17138(this.field_27433);
        if (!this.isSilm) {
            this.setScale(this.field_27433, 1.01f);
        } else {
            this.field_27433.field_3657 -= 0.3f;
            this.field_27433.field_37938 = 0.8f;
            this.field_27433.field_37939 = 1.01f;
        }
        this.setScale(leftArm, 1.0f);
        class_630 rightArm = this.bodyRoot.method_32086("right_arm");
        rightArm.method_17138(this.field_3401);
        if (!this.isSilm) {
            this.setScale(this.field_3401, 1.01f);
        } else {
            this.field_3401.field_3657 += 0.3f;
            this.field_3401.field_37938 = 0.8f;
            this.field_3401.field_37939 = 1.01f;
        }
        this.setScale(rightArm, 1.0f);
        class_630 leftLeg = this.bodyRoot.method_32086("left_leg");
        leftLeg.method_17138(this.field_3397);
        class_630 rightLeg = this.bodyRoot.method_32086("right_leg");
        rightLeg.method_17138(this.field_3392);
        class_630 leftBoot = this.bodyRoot.method_32086("left_boot");
        leftBoot.method_17138(this.field_3397);
        class_630 rightBoot = this.bodyRoot.method_32086("right_boot");
        rightBoot.method_17138(this.field_3392);
    }

    public void render(class_1309 livingEntity, class_4587 matrixStack, class_4597 vertexConsumerProvider, class_4588 vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        class_1921 COSMIC_ARMOR_RENDER_TYPE = AvaritiaRenderLayers.COSMIC_ARMOR_RENDER_TYPE;
        class_310 mc = class_310.method_1551();
        class_1792 headItem = livingEntity.method_6118(class_1304.field_6169).method_7909();
        class_1792 chestItem = livingEntity.method_6118(class_1304.field_6174).method_7909();
        class_1792 legsItem = livingEntity.method_6118(class_1304.field_6172).method_7909();
        class_1792 feetItem = livingEntity.method_6118(class_1304.field_6166).method_7909();
        long time = mc.field_1687.method_8510();
        double pulse = Math.sin((double)time / 10.0) * 0.5 + 0.5;
        double pulse_mag_sqr = pulse * pulse * pulse * pulse * pulse * pulse;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaShaders.cosmicInventoryRender) {
            scale = 100.0f;
        } else {
            yaw = (float)((double)(livingEntity.method_36454() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(livingEntity.method_36455() * 2.0f) * Math.PI / 360.0));
        }
        AvaritiaShaders.timeArmorUniform.method_1251((float)(time % Integer.MAX_VALUE));
        AvaritiaShaders.yawArmorUniform.method_1251(yaw);
        AvaritiaShaders.pitchArmorUniform.method_1251(pitch);
        AvaritiaShaders.externalScaleArmorUniform.method_1251(scale);
        AvaritiaShaders.opacityArmorUniform.method_1251(0.9f);
        AvaritiaShaders.cosmicuvsArmorUniform.method_1253(AvaritiaShaders.COSMIC_UVS);
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            class_1799 itemStack = livingEntity.method_6118(class_1304.field_6174);
            if (chestItem == AvaritiaItems.INFINITY_CHESTPLATE && (player.method_31549().field_7479 || itemStack.method_57826(AvaritiaDataComponents.FLY) && ((Boolean)itemStack.method_57825(AvaritiaDataComponents.FLY, (Object)false)).booleanValue())) {
                matrixStack.method_22903();
                class_630 leftWing = this.root.method_32086("left_wing");
                class_630 rightWing = this.root.method_32086("right_wing");
                leftWing.method_22698(matrixStack, vertexConsumer, packedLight, packedOverlay);
                rightWing.method_22698(matrixStack, vertexConsumer, packedLight, packedOverlay);
                leftWing.method_22699(matrixStack, WING_MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
                rightWing.method_22699(matrixStack, WING_MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
                leftWing.method_22699(matrixStack, vertexConsumerProvider.getBuffer(AvaritiaRenderLayers.WingGlow(WING_GLOW)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
                rightWing.method_22699(matrixStack, vertexConsumerProvider.getBuffer(AvaritiaRenderLayers.WingGlow(WING_GLOW)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
                matrixStack.method_22909();
            }
        }
        if (headItem == AvaritiaItems.INFINITY_HELMET) {
            matrixStack.method_22903();
            class_630 head = this.bodyRoot.method_32086("head");
            head.method_22699(matrixStack, MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            class_630 hat = this.bodyRoot.method_32086("hat");
            hat.method_22699(matrixStack, MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            matrixStack.method_22909();
        }
        if (chestItem == AvaritiaItems.INFINITY_CHESTPLATE) {
            matrixStack.method_22903();
            class_630 body = this.bodyRoot.method_32086("body");
            body.method_22699(matrixStack, MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            body.method_22699(matrixStack, vertexConsumerProvider.getBuffer(AvaritiaRenderLayers.WingGlow(EYE)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
            class_630 leftArm = this.bodyRoot.method_32086("left_arm");
            leftArm.method_22699(matrixStack, MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            leftArm.method_22699(matrixStack, vertexConsumerProvider.getBuffer(AvaritiaRenderLayers.WingGlow(EYE)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
            class_630 rightArm = this.bodyRoot.method_32086("right_arm");
            rightArm.method_22699(matrixStack, MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            rightArm.method_22699(matrixStack, vertexConsumerProvider.getBuffer(AvaritiaRenderLayers.WingGlow(EYE)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
            matrixStack.method_22909();
        }
        if (legsItem == AvaritiaItems.INFINITY_LEGGINGS) {
            matrixStack.method_22903();
            class_630 leftLeg = this.bodyRoot.method_32086("left_leg");
            leftLeg.method_22699(matrixStack, MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            leftLeg.method_22699(matrixStack, vertexConsumerProvider.getBuffer(AvaritiaRenderLayers.WingGlow(EYE)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
            class_630 rightLeg = this.bodyRoot.method_32086("right_leg");
            rightLeg.method_22699(matrixStack, MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            rightLeg.method_22699(matrixStack, vertexConsumerProvider.getBuffer(AvaritiaRenderLayers.WingGlow(EYE)), packedLight, packedOverlay, new Color(0.84f, 1.0f, 0.95f, (float)(pulse_mag_sqr * 0.5)).getRGB());
            matrixStack.method_22909();
        }
        if (feetItem == AvaritiaItems.INFINITY_BOOTS) {
            matrixStack.method_22903();
            class_630 leftBoot = this.bodyRoot.method_32086("left_boot");
            leftBoot.method_22699(matrixStack, MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            class_630 rightBoot = this.bodyRoot.method_32086("right_boot");
            rightBoot.method_22699(matrixStack, MASK.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            matrixStack.method_22909();
        }
        if (headItem == AvaritiaItems.INFINITY_HELMET && chestItem == AvaritiaItems.INFINITY_CHESTPLATE && legsItem == AvaritiaItems.INFINITY_LEGGINGS && feetItem == AvaritiaItems.INFINITY_BOOTS) {
            matrixStack.method_22903();
            class_630 hat = this.bodyRoot.method_32086("hat");
            float hue = (float)(System.currentTimeMillis() - AvaritiaClientEvent.lastTime) / 2000.0f;
            int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
            hat.method_22699(matrixStack, vertexConsumerProvider.getBuffer(AvaritiaRenderLayers.Glow(EYE)), packedLight, packedOverlay, new Color(r, g, b, alpha).getRGB());
            super.method_2828(matrixStack, MASK_INV.method_24108(vertexConsumerProvider.getBuffer(COSMIC_ARMOR_RENDER_TYPE)), packedLight, packedOverlay, new Color(red, green, blue, alpha).getRGB());
            matrixStack.method_22909();
        }
    }
}

