/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.model.obj;

import de.javagl.obj.FloatTuple;
import de.javagl.obj.Mtl;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjSplitting;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4730;

public class OBJBuilder {
    public static final class_4730 DEFAULT_SPRITE = new class_4730(class_1059.field_5275, null);
    private MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
    private QuadEmitter quadEmitter = this.meshBuilder.getEmitter();
    private final Obj obj;
    private final List<Mtl> mtlList;
    private Function<class_4730, class_1058> textureGetter;

    public OBJBuilder(Obj obj, List<Mtl> mtlList) {
        this.obj = obj;
        this.mtlList = mtlList;
    }

    private void addVertex(int faceIndex, int vertIndex, FloatTuple vertex, FloatTuple normal, QuadEmitter emitter, class_1058 mtlSprite, Obj matGroup, boolean degenerate) {
        int textureCoordIndex = vertIndex;
        if (degenerate) {
            --textureCoordIndex;
        }
        this.quadEmitter.pos(vertIndex, vertex.getX(), vertex.getY(), vertex.getZ());
        this.quadEmitter.normal(vertIndex, normal.getX(), normal.getY(), normal.getZ());
        if (this.obj.getNumTexCoords() > 0) {
            FloatTuple text = matGroup.getTexCoord(matGroup.getFace(faceIndex).getTexCoordIndex(textureCoordIndex));
            this.quadEmitter.sprite(vertIndex, 0, text.getX(), 1.0f - text.getY());
        } else {
            this.quadEmitter.nominalFace(class_2350.method_10147((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()));
        }
    }

    public Mesh build() {
        Map<String, Obj> materialGroups = ObjSplitting.splitByMaterialGroups(this.obj);
        for (Map.Entry<String, Obj> entry : materialGroups.entrySet()) {
            String matName = entry.getKey();
            Obj matGroupObj = entry.getValue();
            Mtl mtl = this.findMtlForName(matName);
            class_1058 mtlSprite = this.textureGetter.apply(DEFAULT_SPRITE);
            if (mtl != null) {
                mtlSprite = this.getMtlSprite(class_2960.method_60654((String)mtl.getMapKd()));
            }
            for (int i = 0; i < matGroupObj.getNumFaces(); ++i) {
                FloatTuple vertex = null;
                FloatTuple normal = null;
                for (int v = 0; v < matGroupObj.getFace(i).getNumVertices(); ++v) {
                    vertex = matGroupObj.getVertex(matGroupObj.getFace(i).getVertexIndex(v));
                    normal = matGroupObj.getNormal(matGroupObj.getFace(i).getNormalIndex(v));
                    this.addVertex(i, v, vertex, normal, this.quadEmitter, mtlSprite, matGroupObj, false);
                }
                if (matGroupObj.getFace(i).getNumVertices() == 3) {
                    this.addVertex(i, 3, vertex, normal, this.quadEmitter, mtlSprite, matGroupObj, true);
                }
                this.quadEmitter.spriteColor(0, -1, -1, -1, -1);
                this.quadEmitter.material(RendererAccess.INSTANCE.getRenderer().materialFinder().find());
                this.quadEmitter.colorIndex(1);
                this.quadEmitter.spriteBake(0, mtlSprite, 32);
                this.quadEmitter.emit();
            }
        }
        return this.meshBuilder.build();
    }

    public List<Mtl> getMtlList() {
        return this.mtlList;
    }

    public Mtl findMtlForName(String name) {
        for (Mtl mtl : this.mtlList) {
            if (!mtl.getName().equals(name)) continue;
            return mtl;
        }
        return null;
    }

    public class_1058 getMtlSprite(class_2960 name) {
        return this.textureGetter.apply(new class_4730(class_1059.field_5275, name));
    }

    public void setTextureGetter(Function<class_4730, class_1058> textureGetter) {
        this.textureGetter = textureGetter;
    }
}

