/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.byAqua3.avaritia.item.ItemInfinitySingularity;
import net.byAqua3.avaritia.item.ItemJsonSingularity;
import net.byAqua3.avaritia.item.ItemSingularity;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaItems;
import net.byAqua3.avaritia.loader.AvaritiaRecipes;
import net.byAqua3.avaritia.loader.AvaritiaSingularities;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.recipe.ingredient.DataComponentIngredient;
import net.byAqua3.avaritia.singularity.Singularity;
import net.byAqua3.avaritia.util.AvaritiaRecipeUtils;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public class RecipeExtremeShapeless
implements RecipeExtremeCrafting {
    public final String group;
    public final class_1799 result;
    public final class_2371<class_1856> ingredients;
    public final boolean hasSingularities;
    private final boolean isSimple;

    public RecipeExtremeShapeless(String group, class_1799 result, List<class_1856> ingredients, boolean hasSingularities) {
        this.group = group;
        this.result = result;
        this.ingredients = class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new)));
        this.hasSingularities = hasSingularities;
        this.isSimple = hasSingularities ? false : this.method_8117().stream().allMatch(ingredient -> !ingredient.requiresTesting());
    }

    public boolean matches(class_9694 container, class_1937 level) {
        class_1662 recipeMatcher = new class_1662();
        ArrayList<class_1799> inputs = new ArrayList<class_1799>();
        int i = 0;
        for (int j = 0; j < container.method_59983(); ++j) {
            class_1799 itemstack = container.method_59984(j);
            if (itemstack.method_7960()) continue;
            ++i;
            if (this.isSimple) {
                recipeMatcher.method_20478(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.method_8117().size() && (this.isSimple ? recipeMatcher.method_7402((class_1860)this, null) : AvaritiaRecipeUtils.findMatches(inputs, this.method_8117()) != null);
    }

    public boolean method_49188() {
        return false;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.method_8117().size();
    }

    public class_1799 craft(class_9694 container, class_7225.class_7874 registryAccess) {
        return this.method_8110(registryAccess).method_7972();
    }

    public String method_8112() {
        return this.group;
    }

    public class_1799 method_8110(class_7225.class_7874 registryAccess) {
        return this.result;
    }

    public class_2371<class_1856> method_8117() {
        if (this.hasSingularities) {
            class_2371 ingredients = class_2371.method_10211();
            ingredients.addAll(this.ingredients);
            for (int i = 0; i < AvaritiaItems.ITEMS.size(); ++i) {
                class_1792 item = AvaritiaItems.ITEMS.get(i);
                if (!(item instanceof ItemSingularity) || item instanceof ItemInfinitySingularity) continue;
                if (!(item instanceof ItemJsonSingularity)) {
                    ingredients.add((Object)class_1856.method_8091((class_1935[])new class_1935[]{item}));
                    continue;
                }
                for (Singularity singularity : AvaritiaSingularities.getInstance().getSingularities()) {
                    class_1799 itemStack = new class_1799((class_1935)item);
                    itemStack.method_57379(AvaritiaDataComponents.SINGULARITY_ID, (Object)singularity.getId());
                    ingredients.add((Object)DataComponentIngredient.of(itemStack));
                }
            }
            return ingredients;
        }
        return this.ingredients;
    }

    public class_1865<?> method_8119() {
        return AvaritiaRecipes.EXTREME_SHAPELESS_RECIPE;
    }

    public static class Serializer
    implements class_1865<RecipeExtremeShapeless> {
        public static final MapCodec<RecipeExtremeShapeless> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)class_1799.field_51397.fieldOf("result").forGetter(recipe -> recipe.result), (App)class_1856.field_46096.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)Codec.BOOL.optionalFieldOf("singularities", (Object)false).forGetter(recipe -> recipe.hasSingularities)).apply((Applicative)instance, RecipeExtremeShapeless::new));
        public static final class_9139<class_9129, RecipeExtremeShapeless> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<RecipeExtremeShapeless> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, RecipeExtremeShapeless> method_56104() {
            return STREAM_CODEC;
        }

        private static RecipeExtremeShapeless fromNetwork(class_9129 friendlyByteBuf) {
            String group = friendlyByteBuf.method_19772();
            int i = friendlyByteBuf.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)((class_1856)class_1856.field_48355.decode((Object)friendlyByteBuf)));
            }
            class_1799 itemStack = (class_1799)class_1799.field_48349.decode((Object)friendlyByteBuf);
            boolean hasSingularities = friendlyByteBuf.readBoolean();
            return new RecipeExtremeShapeless(group, itemStack, (List<class_1856>)ingredients, hasSingularities);
        }

        private static void toNetwork(class_9129 friendlyByteBuf, RecipeExtremeShapeless recipe) {
            friendlyByteBuf.method_10814(recipe.group);
            friendlyByteBuf.method_10804(recipe.ingredients.size());
            for (class_1856 ingredient : recipe.ingredients) {
                class_1856.field_48355.encode((Object)friendlyByteBuf, (Object)ingredient);
            }
            class_1799.field_48349.encode((Object)friendlyByteBuf, (Object)recipe.result);
            friendlyByteBuf.method_52964(recipe.hasSingularities);
        }
    }
}

