/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public final class ShapedRecipePattern {
    static int maxWidth = 3;
    static int maxHeight = 3;
    public static final MapCodec<ShapedRecipePattern> MAP_CODEC = Data.MAP_CODEC.flatXmap(ShapedRecipePattern::unpack, p_344423_ -> p_344423_.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final class_9139<class_9129, ShapedRecipePattern> STREAM_CODEC = class_9139.method_56438(ShapedRecipePattern::toNetwork, ShapedRecipePattern::fromNetwork);
    private final int width;
    private final int height;
    private final class_2371<class_1856> ingredients;
    private final Optional<Data> data;
    private final int ingredientCount;
    private final boolean symmetrical;

    public static int getMaxWidth() {
        return maxWidth;
    }

    public static int getMaxHeight() {
        return maxHeight;
    }

    public static void setCraftingSize(int width, int height) {
        if (maxWidth < width) {
            maxWidth = width;
        }
        if (maxHeight < height) {
            maxHeight = height;
        }
    }

    public ShapedRecipePattern(int width, int height, class_2371<class_1856> ingredients, Optional<Data> data) {
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.data = data;
        int i = 0;
        for (class_1856 ingredient : ingredients) {
            if (ingredient.method_8103()) continue;
            ++i;
        }
        this.ingredientCount = i;
        this.symmetrical = class_156.method_59901((int)width, (int)height, ingredients);
    }

    public static ShapedRecipePattern of(Map<Character, class_1856> pKey, String ... pPattern) {
        return ShapedRecipePattern.of(pKey, List.of(pPattern));
    }

    public static ShapedRecipePattern of(Map<Character, class_1856> pKey, List<String> pPattern) {
        Data shapedrecipepattern$data = new Data(pKey, pPattern);
        return (ShapedRecipePattern)ShapedRecipePattern.unpack(shapedrecipepattern$data).getOrThrow();
    }

    private static DataResult<ShapedRecipePattern> unpack(Data p_312037_) {
        String[] astring = ShapedRecipePattern.shrink(p_312037_.pattern);
        int i = astring[0].length();
        int j = astring.length;
        class_2371 nonnulllist = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
        CharArraySet charset = new CharArraySet(p_312037_.key.keySet());
        for (int k = 0; k < astring.length; ++k) {
            String s = astring[k];
            for (int l = 0; l < s.length(); ++l) {
                class_1856 ingredient;
                char c0 = s.charAt(l);
                class_1856 class_18562 = ingredient = c0 == ' ' ? class_1856.field_9017 : p_312037_.key.get(Character.valueOf(c0));
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + c0 + "' but it's not defined in the key");
                }
                charset.remove(c0);
                nonnulllist.set(l + i * k, (Object)ingredient);
            }
        }
        return !charset.isEmpty() ? DataResult.error(() -> ShapedRecipePattern.lambda$unpack$4((CharSet)charset)) : DataResult.success((Object)new ShapedRecipePattern(i, j, (class_2371<class_1856>)nonnulllist, Optional.of(p_312037_)));
    }

    @VisibleForTesting
    static String[] shrink(List<String> pPattern) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < pPattern.size(); ++i1) {
            String s = pPattern.get(i1);
            i = Math.min(i, ShapedRecipePattern.firstNonSpace(s));
            int j1 = ShapedRecipePattern.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pPattern.size() == l) {
            return new String[0];
        }
        String[] astring = new String[pPattern.size() - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = pPattern.get(k1 + k).substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String pRow) {
        int i;
        for (i = 0; i < pRow.length() && pRow.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String pRow) {
        int i;
        for (i = pRow.length() - 1; i >= 0 && pRow.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public boolean matches(class_9694 input) {
        if (input.method_59990() != this.ingredientCount) {
            return false;
        }
        if (input.method_59991() == this.width && input.method_59992() == this.height) {
            if (!this.symmetrical && this.matches(input, true)) {
                return true;
            }
            if (this.matches(input, false)) {
                return true;
            }
        }
        return false;
    }

    private boolean matches(class_9694 input, boolean symmetrical) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                class_1799 itemStack;
                class_1856 ingredient = symmetrical ? (class_1856)this.ingredients.get(this.width - j - 1 + i * this.width) : (class_1856)this.ingredients.get(j + i * this.width);
                if (ingredient.method_8093(itemStack = input.method_59985(j, i))) continue;
                return false;
            }
        }
        return true;
    }

    private void toNetwork(class_9129 registryByteBuf) {
        registryByteBuf.method_10804(this.width);
        registryByteBuf.method_10804(this.height);
        for (class_1856 ingredient : this.ingredients) {
            class_1856.field_48355.encode((Object)registryByteBuf, (Object)ingredient);
        }
    }

    private static ShapedRecipePattern fromNetwork(class_9129 registryByteBuf) {
        int i = registryByteBuf.method_10816();
        int j = registryByteBuf.method_10816();
        class_2371 list = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
        list.replaceAll(operator -> (class_1856)class_1856.field_48355.decode((Object)registryByteBuf));
        return new ShapedRecipePattern(i, j, (class_2371<class_1856>)list, Optional.empty());
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public class_2371<class_1856> ingredients() {
        return this.ingredients;
    }

    private static /* synthetic */ String lambda$unpack$4(CharSet charset) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charset);
    }

    public record Data(Map<Character, class_1856> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(p_312085_ -> {
            if (p_312085_.size() > maxHeight) {
                return DataResult.error(() -> "Invalid pattern: too many rows, %s is maximum".formatted(maxHeight));
            }
            if (p_312085_.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)p_312085_.getFirst()).length();
            for (String s : p_312085_) {
                if (s.length() > maxWidth) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, %s is maximum".formatted(maxWidth));
                }
                if (i == s.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)p_312085_);
        }, Function.identity());
        private static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap(p_312250_ -> {
            if (p_312250_.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + p_312250_ + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(p_312250_) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(p_312250_.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Data> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.method_53703(SYMBOL_CODEC, (Codec)class_1856.field_46096).fieldOf("key").forGetter(p_312509_ -> p_312509_.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(p_312713_ -> p_312713_.pattern)).apply((Applicative)instance, Data::new));
    }
}

