/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import net.byAqua3.avaritia.entity.EntityGapingVoid;
import net.byAqua3.avaritia.loader.AvaritiaRenderLayers;
import net.byAqua3.avaritia.model.obj.OBJBuilder;
import net.byAqua3.avaritia.model.obj.OBJLoader;
import net.byAqua3.avaritia.util.DefaultVertexFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_757;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class RenderGapingVoid
extends class_897<EntityGapingVoid> {
    public static final class_2960 VOID = class_2960.method_60655((String)"avaritia", (String)"textures/entity/void/void.png");
    public static final class_2960 VOID_HALO = class_2960.method_60655((String)"avaritia", (String)"textures/entity/void/void_halo.png");
    public Mesh mesh;

    public RenderGapingVoid(class_5617.class_5618 context) {
        super(context);
        class_310 mc = class_310.method_1551();
        class_1059 spriteAtlasTexture = mc.method_1554().method_24153(class_1059.field_5275);
        class_2960 resourceId = class_2960.method_60655((String)"avaritia", (String)"model/model.obj");
        Optional optional = mc.method_1478().method_14486(resourceId);
        class_1058 texture = spriteAtlasTexture.method_4608(class_2960.method_60655((String)"avaritia", (String)"entity/void/void"));
        if (optional.isPresent()) {
            try {
                InputStream inputStream = ((class_3298)optional.get()).method_14482();
                OBJBuilder objBuilder = OBJLoader.INSTANCE.loadModel(mc.method_1478(), inputStream, "avaritia");
                objBuilder.setTextureGetter(sprite -> texture);
                this.mesh = objBuilder.build();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Color getColor(double age) {
        double life = age / 186.0;
        double f = Math.max(0.0, (life - 0.95) / 0.050000000000000044);
        f = Math.max(f, 1.0 - life * 30.0);
        return new Color((float)f, (float)f, (float)f, 1.0f);
    }

    public void render(EntityGapingVoid livingEntity, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 vertexConsumerProvider, int packedLight) {
        Color color = this.getColor(livingEntity.getAge());
        float scale = (float)EntityGapingVoid.getVoidScale(livingEntity.getAge());
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        double halocoord = 0.58 * (double)scale;
        double haloscaledist = 2.2 * (double)scale;
        class_243 camera = this.field_4676.field_4686.method_19326();
        double dx = livingEntity.method_23317() - camera.field_1352;
        double dy = livingEntity.method_23318() - camera.field_1351;
        double dz = livingEntity.method_23321() - camera.field_1350;
        double xzlen = Math.sqrt(dx * dx + dz * dz);
        double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (len <= haloscaledist) {
            double close = (haloscaledist - len) / haloscaledist;
            halocoord *= 1.0 + close * close * close * close * 1.5;
        }
        double yang = Math.atan2(xzlen, dy) * 57.29577951308232;
        double xang = Math.atan2(dx, dz) * 57.29577951308232;
        matrixStack.method_22903();
        matrixStack.method_46416(0.5f, 0.5f, 0.5f);
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees((float)xang));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees((float)(yang + 275.0)));
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (class_2960)VOID_HALO);
        RenderSystem.setShader(class_757::method_34543);
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.method_22918(matrix4f, (float)(-halocoord), (float)(-halocoord), 0.0f).method_22915(r, g, b, a).method_22913(0.0f, 0.0f);
        bufferBuilder.method_22918(matrix4f, (float)(-halocoord), (float)halocoord, 0.0f).method_22915(r, g, b, a).method_22913(0.0f, 1.0f);
        bufferBuilder.method_22918(matrix4f, (float)halocoord, (float)halocoord, 0.0f).method_22915(r, g, b, a).method_22913(1.0f, 1.0f);
        bufferBuilder.method_22918(matrix4f, (float)halocoord, (float)(-halocoord), 0.0f).method_22915(r, g, b, a).method_22913(1.0f, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.method_22909();
        matrixStack.method_22903();
        class_4587.class_4665 matrixstack$peek = matrixStack.method_23760();
        matrixStack.method_46416(0.5f, 0.25f, 0.5f);
        matrixStack.method_22905(scale - 0.1f, scale - 0.1f, scale - 0.1f);
        if (this.mesh != null) {
            List[] quadLists;
            for (List quads : quadLists = ModelHelper.toQuadLists((Mesh)this.mesh)) {
                for (class_777 quad : quads) {
                    vertexConsumerProvider.getBuffer(AvaritiaRenderLayers.VOID).method_22919(matrixstack$peek, quad, r, g, b, a, packedLight, class_4608.field_21444);
                }
            }
        }
        matrixStack.method_22909();
    }

    public class_2960 getTexture(EntityGapingVoid entity) {
        return VOID;
    }
}

