/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.tile;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.byAqua3.avaritia.Avaritia;
import net.byAqua3.avaritia.component.ClusterContainerContents;
import net.byAqua3.avaritia.gui.GuiInfinityChest;
import net.byAqua3.avaritia.inventory.InventoryInfinityChest;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9326;

public class TileInfinityChest
extends class_2586 {
    public final InventoryInfinityChest chest = new InventoryInfinityChest(300){

        public void method_5431() {
            TileInfinityChest.this.method_5431();
        }
    };
    public boolean start;
    public boolean stop;
    public float lidAngle;
    public boolean updateStop;
    public static final Codec<class_1799> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_47312.fieldOf("id").forGetter(class_1799::method_41409), (App)class_5699.method_48766((int)1, (int)Integer.MAX_VALUE).fieldOf("count").orElse((Object)1).forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(itemStack -> itemStack.method_57380())).apply((Applicative)instance, class_1799::new)));

    public TileInfinityChest(class_2338 pos, class_2680 state) {
        super(AvaritiaBlocks.INFINITY_CHEST_TILE, pos, state);
    }

    private void playSound(class_3414 sound) {
        class_1937 level = this.method_10997();
        class_2338 blockPos = this.method_11016();
        level.method_8486((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), sound, class_3419.field_15245, 0.5f, level.field_9229.method_43057() * 0.1f + 0.9f, false);
    }

    public void onStart() {
        if (this.lidAngle < 1.0f) {
            this.playSound(class_3417.field_14982);
        }
        this.start = true;
        this.stop = false;
    }

    public void onStop() {
        if (this.lidAngle > 0.0f) {
            this.playSound(class_3417.field_14823);
        }
        this.start = false;
        this.stop = true;
    }

    public void update() {
        if (this.start) {
            this.lidAngle += 0.1f;
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
                this.start = false;
            }
        }
        if (this.stop) {
            this.lidAngle -= 0.1f;
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
                this.stop = false;
            }
        }
        this.updateStop();
    }

    public void updateStop() {
        class_310 mc = class_310.method_1551();
        if (!this.updateStop) {
            if (!this.start && !this.stop && !(mc.field_1755 instanceof GuiInfinityChest) && this.lidAngle >= 1.0f) {
                this.updateStop = true;
            }
            if (this.start && !this.stop && mc.field_1755 instanceof GuiInfinityChest) {
                this.updateStop = true;
            }
        } else if (!(mc.field_1755 instanceof GuiInfinityChest)) {
            this.start = false;
            this.stop = true;
            this.updateStop = false;
        }
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10573("Items", 9)) {
            class_2499 tagList = tag.method_10554("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                class_2487 compoundTag = tagList.method_10602(i);
                int j = compoundTag.method_10550("Slot");
                if (j < 0 || j >= this.chest.field_5828.size()) continue;
                class_1799 itemStack = CODEC.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)compoundTag).resultOrPartial(error -> Avaritia.LOGGER.error("Tried to load invalid item: '{}'", error)).orElse(class_1799.field_8037);
                this.chest.field_5828.set(j, (Object)itemStack);
            }
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        class_2499 tagList = new class_2499();
        for (int i = 0; i < this.chest.field_5828.size(); ++i) {
            class_1799 itemStack = (class_1799)this.chest.field_5828.get(i);
            if (itemStack.method_7960()) continue;
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10569("Slot", i);
            tagList.add((Object)((class_2520)CODEC.encode((Object)itemStack, (DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)compoundTag).getOrThrow()));
        }
        if (!tagList.isEmpty()) {
            tag.method_10566("Items", (class_2520)tagList);
        }
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        super.method_57568(componentInput);
        class_2371 itemStacks = class_2371.method_10213((int)300, (Object)class_1799.field_8037);
        ((ClusterContainerContents)componentInput.method_58695(AvaritiaDataComponents.CLUSTER_CONTAINER, (Object)ClusterContainerContents.EMPTY)).copyInto((class_2371<class_1799>)itemStacks);
        if (!itemStacks.isEmpty()) {
            for (int i = 0; i < itemStacks.size(); ++i) {
                this.chest.field_5828.set(i, (Object)((class_1799)itemStacks.get(i)));
            }
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        class_2371 itemStacks = this.chest.field_5828;
        builder.method_57840(AvaritiaDataComponents.CLUSTER_CONTAINER, (Object)ClusterContainerContents.fromItems((List<class_1799>)itemStacks));
    }
}

