/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.transfer;

import java.util.Objects;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.transfer.InventoryStorageInfinityChest;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.fabricmc.fabric.impl.transfer.item.SpecialLogicInventory;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public class InventorySlotInfinityChest
extends SingleStackStorage {
    private final InventoryStorageInfinityChest storage;
    final int slot;
    private final SpecialLogicInventory specialInv;
    private class_1799 lastReleasedSnapshot = null;

    InventorySlotInfinityChest(InventoryStorageInfinityChest storage, int slot) {
        SpecialLogicInventory specialInv;
        this.storage = storage;
        this.slot = slot;
        class_1263 class_12632 = storage.inventory;
        this.specialInv = class_12632 instanceof SpecialLogicInventory ? (specialInv = (SpecialLogicInventory)class_12632) : null;
    }

    protected class_1799 getStack() {
        return this.storage.inventory.method_5438(this.slot);
    }

    protected void setStack(class_1799 stack) {
        if (this.specialInv == null) {
            this.storage.inventory.method_5447(this.slot, stack);
        } else {
            this.specialInv.fabric_setSuppress(true);
            try {
                this.storage.inventory.method_5447(this.slot, stack);
            }
            finally {
                this.specialInv.fabric_setSuppress(false);
            }
        }
    }

    public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        int insertedAmount;
        if (!this.canInsert(this.slot, insertedVariant.toStack())) {
            return 0L;
        }
        class_1799 currentStack = this.getStack();
        class_1799 stack = insertedVariant.toStack();
        StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
        stack.method_57368(AvaritiaDataComponents.MAX_STACK_SIZE, (Object)stack.method_7914(), size -> Integer.MAX_VALUE);
        if ((class_1799.method_31577((class_1799)stack, (class_1799)currentStack) || currentStack.method_7960()) && this.canInsert(insertedVariant) && (insertedAmount = (int)Math.max(maxAmount, (long)(this.getCapacity(insertedVariant) - currentStack.method_7947()))) > 0) {
            this.updateSnapshots(transaction);
            currentStack = this.getStack();
            if (currentStack.method_7960()) {
                if (stack.method_7947() <= insertedAmount) {
                    class_1799 copy = stack.method_7972();
                    copy.method_7933(currentStack.method_7947());
                    this.setStack(copy);
                    return stack.method_7947();
                }
                class_1799 copy = stack.method_7972().method_7971(insertedAmount);
                this.setStack(copy);
                return insertedAmount;
            }
            if (currentStack.method_7947() >= this.getCapacity(insertedVariant)) {
                return 0L;
            }
            insertedAmount = (int)Math.max(maxAmount, (long)this.getCapacity(insertedVariant));
            if (stack.method_7947() <= insertedAmount) {
                class_1799 copy = stack.method_7972();
                copy.method_7933(currentStack.method_7947());
                this.setStack(copy);
                return stack.method_7947();
            }
            class_1799 copy = stack.method_7972().method_7971(insertedAmount);
            copy.method_7933(currentStack.method_7947());
            this.setStack(copy);
            return insertedAmount;
        }
        if (this.specialInv != null) {
            this.specialInv.fabric_onTransfer(this.slot, transaction);
        }
        return 0L;
    }

    private boolean canInsert(int slot, class_1799 stack) {
        return this.storage.inventory.method_5437(slot, stack);
    }

    public long extract(ItemVariant variant, long maxAmount, TransactionContext transaction) {
        int extracted;
        StoragePreconditions.notBlankNotNegative((TransferVariant)variant, (long)maxAmount);
        class_1799 currentStack = this.getStack();
        class_1799 stack = variant.toStack();
        if (variant.matches(currentStack) && this.canExtract(variant) && (extracted = (int)Math.min((long)currentStack.method_7947(), maxAmount)) > 0) {
            this.updateSnapshots(transaction);
            class_1799 copy = currentStack.method_7972();
            copy.method_7934(extracted);
            if (stack.method_57826(AvaritiaDataComponents.MAX_STACK_SIZE)) {
                stack.method_57381(AvaritiaDataComponents.MAX_STACK_SIZE);
            }
            this.setStack(copy);
            return extracted;
        }
        if (this.specialInv != null) {
            this.specialInv.fabric_onTransfer(this.slot, transaction);
        }
        return 0L;
    }

    public int getCapacity(ItemVariant variant) {
        return Math.max(this.storage.inventory.method_5444(), variant.getItem().method_7882());
    }

    public void updateSnapshots(TransactionContext transaction) {
        this.storage.markDirtyParticipant.updateSnapshots(transaction);
        super.updateSnapshots(transaction);
    }

    protected void releaseSnapshot(class_1799 snapshot) {
        this.lastReleasedSnapshot = snapshot;
    }

    protected void onFinalCommit() {
        class_1799 original = this.lastReleasedSnapshot;
        class_1799 currentStack = this.getStack();
        class_1263 class_12632 = this.storage.inventory;
        if (class_12632 instanceof SpecialLogicInventory) {
            SpecialLogicInventory specialLogicInv = (SpecialLogicInventory)class_12632;
            specialLogicInv.fabric_onFinalCommit(this.slot, original, currentStack);
        }
        if (!original.method_7960() && original.method_7909() == currentStack.method_7909()) {
            if (!Objects.equals(original.method_57380(), currentStack.method_57380())) {
                for (class_9331 type : original.method_57353().method_57831()) {
                    original.method_57379(type, null);
                }
                original.method_57365(currentStack.method_57353());
            }
            original.method_7939(currentStack.method_7947());
            this.setStack(original);
        } else {
            original.method_7939(0);
        }
    }

    public String toString() {
        return "InventorySlotWrapper[%s#%d]".formatted(DebugMessages.forInventory((class_1263)this.storage.inventory), this.slot);
    }
}

