/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.util;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.byAqua3.avaritia.inventory.ContainerExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeCollector;
import net.byAqua3.avaritia.recipe.RecipeCompressor;
import net.byAqua3.avaritia.recipe.RecipeExtremeCrafting;
import net.byAqua3.avaritia.recipe.RecipeExtremeShaped;
import net.byAqua3.avaritia.recipe.RecipeExtremeShapeless;
import net.byAqua3.avaritia.recipe.ShapedRecipePattern;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class AvaritiaRecipeUtils {
    public static List<RecipeExtremeCrafting> getExtremeCraftingRecipes(final class_1937 level) {
        Collection recipes = level.method_8433().method_8126();
        ArrayList<RecipeExtremeCrafting> recipeList = new ArrayList<RecipeExtremeCrafting>();
        for (class_8786 recipeEntry : recipes) {
            class_1860 recipe = recipeEntry.comp_1933();
            if (!(recipe instanceof RecipeExtremeShaped) && !(recipe instanceof RecipeExtremeShapeless)) continue;
            RecipeExtremeCrafting recipeExtremeCrafting = (RecipeExtremeCrafting)recipe;
            recipeList.add(recipeExtremeCrafting);
        }
        recipeList.sort(new Comparator<RecipeExtremeCrafting>(){

            @Override
            public int compare(RecipeExtremeCrafting recipe1, RecipeExtremeCrafting recipe2) {
                int itemId1 = class_7923.field_41178.method_10206((Object)recipe1.method_8110((class_7225.class_7874)level.method_30349()).method_7909());
                int itemId2 = class_7923.field_41178.method_10206((Object)recipe2.method_8110((class_7225.class_7874)level.method_30349()).method_7909());
                return Integer.valueOf(itemId1).compareTo(itemId2);
            }
        });
        return recipeList;
    }

    public static List<RecipeCompressor> getCompressorRecipes(final class_1937 level) {
        Collection recipes = level.method_8433().method_8126();
        ArrayList<RecipeCompressor> recipeList = new ArrayList<RecipeCompressor>();
        for (class_8786 recipeEntry : recipes) {
            RecipeCompressor recipeCompressor;
            class_1860 recipe = recipeEntry.comp_1933();
            if (!(recipe instanceof RecipeCompressor) || (recipeCompressor = (RecipeCompressor)recipe).method_8117().isEmpty()) continue;
            recipeList.add(recipeCompressor);
        }
        recipeList.sort(new Comparator<RecipeCompressor>(){

            @Override
            public int compare(RecipeCompressor recipe1, RecipeCompressor recipe2) {
                int itemId1 = class_7923.field_41178.method_10206((Object)recipe1.method_8110((class_7225.class_7874)level.method_30349()).method_7909());
                int itemId2 = class_7923.field_41178.method_10206((Object)recipe2.method_8110((class_7225.class_7874)level.method_30349()).method_7909());
                return Integer.valueOf(itemId1).compareTo(itemId2);
            }
        });
        return recipeList;
    }

    public static List<RecipeCollector> getCollectorRecipes(class_1937 level) {
        ArrayList<RecipeCollector> recipeList = new ArrayList<RecipeCollector>();
        recipeList.add(new RecipeCollector());
        return recipeList;
    }

    public static RecipeCompressor getCompressorRecipe(class_1937 level, class_1799 input) {
        Collection recipes = level.method_8433().method_8126();
        class_1277 matrix = new class_1277(1);
        matrix.method_5491(input);
        ContainerExtremeCrafting crafting = new ContainerExtremeCrafting(null, 1, 1, matrix);
        for (class_8786 recipeEntry : recipes) {
            RecipeCompressor recipeCompressor;
            class_1860 recipe = recipeEntry.comp_1933();
            if (!(recipe instanceof RecipeCompressor) || !(recipeCompressor = (RecipeCompressor)recipe).matches(crafting.method_59961(), level)) continue;
            return recipeCompressor;
        }
        return null;
    }

    public static RecipeCompressor getCompressorRecipeFromResult(class_1937 level, class_1799 result) {
        Collection recipes = level.method_8433().method_8126();
        for (class_8786 recipeEntry : recipes) {
            RecipeCompressor recipeCompressor;
            class_1860 recipe = recipeEntry.comp_1933();
            if (!(recipe instanceof RecipeCompressor) || !class_1799.method_31577((class_1799)(recipeCompressor = (RecipeCompressor)recipe).method_8110((class_7225.class_7874)level.method_30349()), (class_1799)result)) continue;
            return recipeCompressor;
        }
        return null;
    }

    public static RecipeCompressor getCompressorRecipeFromResult(class_1937 level, class_1799 result, class_9331<?> dataComponentType) {
        Collection recipes = level.method_8433().method_8126();
        for (class_8786 recipeEntry : recipes) {
            RecipeCompressor recipeCompressor;
            class_1799 itemStack;
            class_1860 recipe = recipeEntry.comp_1933();
            if (!(recipe instanceof RecipeCompressor) || !class_1799.method_7973((class_1799)(itemStack = (recipeCompressor = (RecipeCompressor)recipe).method_8110((class_7225.class_7874)level.method_30349())), (class_1799)result) || !itemStack.method_57826(dataComponentType) || !result.method_57826(dataComponentType) || itemStack.method_57824(dataComponentType) != result.method_57824(dataComponentType)) continue;
            return recipeCompressor;
        }
        return null;
    }

    public static ShapedRecipePattern createPattern(IIngredient[][] ingredients) {
        int width = ArrayUtil.getMaxWidth((Object[][])ingredients);
        int height = ingredients.length;
        return AvaritiaRecipeUtils.createPattern((class_2371<class_1856>)ArrayUtil.flattenToNNL((int)width, (int)height, (Object[][])ingredients, () -> class_1856.field_9017, IIngredient::asVanillaIngredient), width, height);
    }

    public static ShapedRecipePattern createPattern(class_2371<class_1856> flatIngredients, int width, int height) {
        char start = 'a';
        HashMap<Character, class_1856> keys = new HashMap<Character, class_1856>();
        LinkedList<String> pattern = new LinkedList<String>();
        int ingredientIndex = 0;
        for (int row = 0; row < height; ++row) {
            StringBuilder rowPattern = new StringBuilder();
            for (int col = 0; col < width; ++col) {
                class_1856 ingredient;
                if ((ingredient = (class_1856)flatIngredients.get(ingredientIndex++)).method_8103()) {
                    rowPattern.append(" ");
                    continue;
                }
                char c = start;
                start = (char)(start + 1);
                char key = c;
                keys.put(Character.valueOf(key), ingredient);
                rowPattern.append(key);
            }
            pattern.add(rowPattern.toString());
        }
        return ShapedRecipePattern.of(keys, pattern);
    }

    public static <T> int @Nullable [] findMatches(List<T> inputs, List<? extends Predicate<T>> tests) {
        int elements = inputs.size();
        if (elements != tests.size()) {
            return null;
        }
        int[] ret = new int[elements];
        Arrays.fill(ret, -1);
        BitSet data = new BitSet((elements + 2) * elements);
        for (int x = 0; x < elements; ++x) {
            int matched = 0;
            int offset = (x + 2) * elements;
            Predicate<T> test = tests.get(x);
            for (int y = 0; y < elements; ++y) {
                if (data.get(y) || !test.test(inputs.get(y))) continue;
                data.set(offset + y);
                ++matched;
            }
            if (matched == 0) {
                return null;
            }
            if (matched != true || AvaritiaRecipeUtils.claim(ret, data, x, elements)) continue;
            return null;
        }
        if (data.nextClearBit(0) >= elements) {
            return ret;
        }
        if (AvaritiaRecipeUtils.backtrack(data, ret, 0, elements)) {
            return ret;
        }
        return null;
    }

    private static boolean claim(int[] ret, BitSet data, int claimed, int elements) {
        LinkedList<Integer> pending = new LinkedList<Integer>();
        pending.add(claimed);
        while (pending.peek() != null) {
            int test = (Integer)pending.poll();
            int offset = (test + 2) * elements;
            int used = data.nextSetBit(offset) - offset;
            if (used >= elements || used < 0) {
                throw new IllegalStateException("What? We matched something, but it wasn't set in the range of this test! Test: " + test + " Used: " + used);
            }
            data.set(used);
            data.set(elements + test);
            ret[used] = test;
            for (int x = 0; x < elements; ++x) {
                offset = (x + 2) * elements;
                if (!data.get(offset + used) || data.get(elements + x)) continue;
                data.clear(offset + used);
                int count = 0;
                for (int y = offset; y < offset + elements; ++y) {
                    if (!data.get(y)) continue;
                    ++count;
                }
                if (count == 0) {
                    return false;
                }
                if (count != 1) continue;
                pending.add(x);
            }
        }
        return true;
    }

    private static boolean backtrack(BitSet data, int[] ret, int start, int elements) {
        int test = data.nextClearBit(elements + start) - elements;
        if (test >= elements) {
            return true;
        }
        if (test < 0) {
            throw new IllegalStateException("This should never happen, negative test in backtrack!");
        }
        int offset = (test + 2) * elements;
        for (int x = 0; x < elements; ++x) {
            if (!data.get(offset + x) || data.get(x)) continue;
            data.set(x);
            if (AvaritiaRecipeUtils.backtrack(data, ret, test + 1, elements)) {
                ret[x] = test;
                return true;
            }
            data.clear(x);
        }
        return false;
    }
}

