/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.lumberjack.network;

import com.ryu.minecraft.mod.neoforge.neovillagers.lumberjack.item.crafting.WoodWorkingRecipe;
import com.ryu.minecraft.mod.neoforge.neovillagers.lumberjack.network.ClientboundWoodWorkingRecipesPayload;
import com.ryu.minecraft.mod.neoforge.neovillagers.lumberjack.network.WoodWorkingRecipeInputs;
import com.ryu.minecraft.mod.neoforge.neovillagers.lumberjack.setup.SetupRecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ServerWoodWorkingRecipeInputs
implements WoodWorkingRecipeInputs {
    private final RecipeManager recipeManager;
    private List<RecipeHolder<WoodWorkingRecipe>> recipes = new ArrayList<RecipeHolder<WoodWorkingRecipe>>();

    public ServerWoodWorkingRecipeInputs(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    public void loadRecipes() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            this.recipes = new ArrayList<RecipeHolder<WoodWorkingRecipe>>();
            this.recipeManager.recipeMap().byType(SetupRecipeType.WOODWORKING.get()).forEach(element -> this.recipes.add((RecipeHolder<WoodWorkingRecipe>)element));
        }
    }

    @Override
    public List<RecipeHolder<WoodWorkingRecipe>> recipes() {
        return this.recipes;
    }

    public void syncToClient(Stream<ServerPlayer> players) {
        ClientboundWoodWorkingRecipesPayload payload = new ClientboundWoodWorkingRecipesPayload(this.recipes);
        players.forEach(player -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }
}

