/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.lumberjack.villagers.trades;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class ItemForEmeraldVillagerType
implements VillagerTrades.ItemListing {
    private final Map<ResourceKey<VillagerType>, Item> trades;
    private final int cost;
    private final int maxUses;
    private final int villagerXp;
    private final int numberOfItems;

    public ItemForEmeraldVillagerType(int pCost, int pCount, int pMaxUses, int pVillagerXp, Map<ResourceKey<VillagerType>, Item> pTrades) {
        BuiltInRegistries.VILLAGER_TYPE.registryKeySet().stream().filter(key -> !pTrades.containsKey(key)).findAny().ifPresent(ex -> {
            throw new IllegalStateException("Missing trade for villager type: " + String.valueOf(ex));
        });
        this.trades = pTrades;
        this.cost = pCost;
        this.maxUses = pMaxUses;
        this.villagerXp = pVillagerXp;
        this.numberOfItems = pCount;
    }

    @Nullable
    public MerchantOffer getOffer(Entity pTrader, RandomSource pRandom) {
        if (pTrader instanceof VillagerDataHolder) {
            VillagerDataHolder villagerdataholder = (VillagerDataHolder)pTrader;
            ResourceKey resourcekey = villagerdataholder.getVillagerData().type().unwrapKey().orElse(null);
            if (resourcekey == null) {
                return null;
            }
            ItemCost itemCost = new ItemCost((ItemLike)Items.EMERALD, this.cost);
            ItemStack itemstack = new ItemStack((ItemLike)this.trades.get(resourcekey), this.numberOfItems);
            return new MerchantOffer(itemCost, itemstack, this.maxUses, this.villagerXp, 0.05f);
        }
        return null;
    }
}

