/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.lumberjack.setup;

import com.google.common.collect.ImmutableSet;
import com.ryu.minecraft.mod.neoforge.neovillagers.lumberjack.block.WoodWorkingBlock;
import com.ryu.minecraft.mod.neoforge.neovillagers.lumberjack.setup.SetupBlocks;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SetupVillagers {
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"neovillagerslumberjack");
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)"neovillagerslumberjack");
    public static final ResourceKey<VillagerProfession> LUMBERJACK = SetupVillagers.createKey("lumberjack");
    public static final DeferredHolder<PoiType, PoiType> LUMBERJACK_POI = POI_TYPES.register("lumberjack_poi", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((WoodWorkingBlock)((Object)((Object)SetupBlocks.WOODWORKING.get()))).getStateDefinition().getPossibleStates()), 1, 1));

    private static ResourceKey<VillagerProfession> createKey(String pName) {
        return ResourceKey.create((ResourceKey)Registries.VILLAGER_PROFESSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"neovillagerslumberjack", (String)pName));
    }

    public static void register(IEventBus eventBus) {
        POI_TYPES.register(eventBus);
        VILLAGER_PROFESSIONS.register(eventBus);
    }

    private static VillagerProfession registerVillager() {
        ResourceLocation villagerResource = ResourceLocation.fromNamespaceAndPath((String)"neovillagerslumberjack", (String)"lumberjack");
        MutableComponent villager = Component.translatable((String)("entity." + villagerResource.getNamespace() + ".villager." + villagerResource.getPath()));
        return new VillagerProfession((Component)villager, x -> x.is(LUMBERJACK_POI.getKey()), x -> x.is(LUMBERJACK_POI.getKey()), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.VILLAGER_WORK_FARMER);
    }

    private SetupVillagers() {
    }

    static {
        VILLAGER_PROFESSIONS.register("lumberjack", SetupVillagers::registerVillager);
    }
}

