/*
 * Decompiled with CFR 0.152.
 */
package com.ryu.minecraft.mod.neoforge.neovillagers.lumberjack.villagers.trades;

import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class EnchantedItemForEmeraldsTradeOffer
implements VillagerTrades.ItemListing {
    private final ItemStack itemSell;
    private final int baseEmeraldCost;
    private final int maxUses;
    private final int villagerXp;
    private final float priceMultiplier;

    public EnchantedItemForEmeraldsTradeOffer(Item itemSell, int baseEmeraldCost, int maxUses, int villagerXp) {
        this.itemSell = new ItemStack((ItemLike)itemSell);
        this.baseEmeraldCost = baseEmeraldCost;
        this.maxUses = maxUses;
        this.villagerXp = villagerXp;
        this.priceMultiplier = 0.2f;
    }

    public MerchantOffer getOffer(Entity trader, RandomSource random) {
        int i = 5 + random.nextInt(15);
        RegistryAccess registryaccess = trader.level().registryAccess();
        Optional optional = registryaccess.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.ON_TRADED_EQUIPMENT);
        ItemStack itemstack = EnchantmentHelper.enchantItem((RandomSource)random, (ItemStack)new ItemStack((ItemLike)this.itemSell.getItem()), (int)i, (RegistryAccess)registryaccess, (Optional)optional);
        int j = Math.min(this.baseEmeraldCost + i, 64);
        ItemCost itemcost = new ItemCost((ItemLike)Items.EMERALD, j);
        return new MerchantOffer(itemcost, itemstack, this.maxUses, this.villagerXp, this.priceMultiplier);
    }
}

