/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.smoothgui.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ModConfig {
    private static ModConfig instance;
    private static final Gson GSON;
    private transient File configFile;
    public boolean enableAnimation = true;
    public int animationTime = 150;
    public double animationScale = 1.0;
    public boolean onlyInGame = true;
    public boolean fadeBackground = true;

    public static ModConfig getConfig() {
        if (instance == null) {
            instance = new ModConfig();
        }
        return instance;
    }

    public void load(File configFile) {
        this.configFile = configFile;
        if (!configFile.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            ModConfig loaded = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            this.enableAnimation = loaded.enableAnimation;
            this.animationTime = loaded.animationTime;
            this.animationScale = loaded.animationScale;
            this.onlyInGame = loaded.onlyInGame;
            this.fadeBackground = loaded.fadeBackground;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        if (this.configFile == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        this.enableAnimation = true;
        this.animationTime = 220;
        this.animationScale = 1.0;
        this.onlyInGame = true;
        this.fadeBackground = true;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

