/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.smoothgui;

import com.ezzenix.smoothgui.config.ModConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmoothGui {
    public static final String MOD_ID = "smoothgui";
    public static final String MOD_NAME = "SmoothGui";
    public static final Logger LOG = LoggerFactory.getLogger((String)"SmoothGui");
    public static final String CONFIG_FILE = "smoothgui.json";
    public static long lastScreenOpenedTime = 0L;
    public static long lastScreenChangedTime = 0L;
    private static float appliedDisplacement = 0.0f;
    private static GuiGraphics graphics;

    private static float easeInBack(float t) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return c3 * t * t * t - c1 * t * t;
    }

    public static float getAlphaSince(long time) {
        ModConfig config = ModConfig.getConfig();
        float FADE_TIME = config.animationTime;
        float timeSinceOpen = Math.min((float)(System.currentTimeMillis() - time), FADE_TIME);
        return timeSinceOpen / FADE_TIME;
    }

    public static float calculateDisplacement() {
        ModConfig config = ModConfig.getConfig();
        float FADE_OFFSET = 9.0f;
        float alpha = SmoothGui.getAlphaSince(lastScreenChangedTime);
        return SmoothGui.easeInBack(1.0f - alpha) * FADE_OFFSET * (float)config.animationScale;
    }

    private static boolean isInMainMenu() {
        Minecraft client = Minecraft.getInstance();
        return client.level == null && client.player == null;
    }

    public static boolean isValidScreen(Screen screen) {
        return !(screen instanceof ChatScreen) && !(screen instanceof LevelLoadingScreen) && !(screen instanceof GenericMessageScreen) && !(screen instanceof ReceivingLevelScreen) && !(screen instanceof ConnectScreen) && !(screen instanceof ProgressScreen) && !screen.getClass().getName().equals("RecipesGui");
    }

    public static void push() {
        if (graphics == null) {
            return;
        }
        if (!ModConfig.getConfig().enableAnimation) {
            return;
        }
        if (SmoothGui.isInMainMenu() && ModConfig.getConfig().onlyInGame) {
            return;
        }
        appliedDisplacement = SmoothGui.calculateDisplacement();
        graphics.pose().translate(0.0f, -appliedDisplacement, 0.0f);
    }

    public static void pop() {
        if (graphics == null) {
            return;
        }
        if (appliedDisplacement == 0.0f) {
            return;
        }
        graphics.pose().translate(0.0f, appliedDisplacement, 0.0f);
        appliedDisplacement = 0.0f;
    }

    public static void push(GuiGraphics graphics) {
        SmoothGui.graphics = graphics;
        SmoothGui.push();
    }

    public static void pop(GuiGraphics graphics) {
        SmoothGui.graphics = graphics;
        SmoothGui.pop();
    }
}

