/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.smoothgui;

import com.ezzenix.smoothgui.config.AnimationDirection;
import com.ezzenix.smoothgui.config.ModConfig;
import com.ezzenix.smoothgui.config.ModConfigScreen;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmoothGui {
    public static final String MOD_ID = "smoothgui";
    public static final String MOD_NAME = "SmoothGui";
    public static final Logger LOG = LoggerFactory.getLogger((String)"SmoothGui");
    public static final String CONFIG_FILE = "smoothgui.json";
    private static final Set<Class<?>> BLOCKED_SCREEN_CLASSES = Set.of(ChatScreen.class, LevelLoadingScreen.class, GenericDirtMessageScreen.class, ReceivingLevelScreen.class, ConnectScreen.class, ProgressScreen.class);
    private static final Set<String> BLOCKED_SCREEN_NAMES = Set.of("ModMenuOptionsScreen", "ModsScreen", "RecipesGui");
    public static long lastScreenOpenedTime = 0L;
    public static long lastScreenChangedTime = 0L;
    private static float appliedDisplacement = 0.0f;
    private static GuiGraphics graphics;

    public static float getAlphaSince(long time) {
        ModConfig config = ModConfig.getConfig();
        float FADE_TIME = config.animationTime;
        float timeSinceOpen = Math.min((float)(System.currentTimeMillis() - time), FADE_TIME);
        return timeSinceOpen / FADE_TIME;
    }

    public static float calculateDisplacement() {
        ModConfig config = ModConfig.getConfig();
        float FADE_OFFSET = 9.0f;
        float alpha = SmoothGui.getAlphaSince(lastScreenChangedTime);
        float directionMod = config.animationDirection.equals((Object)AnimationDirection.DOWN) ? 1.0f : -1.0f;
        return FADE_OFFSET * config.animationStyle.get(1.0f - alpha) * (float)config.animationScale * directionMod;
    }

    private static boolean isInMainMenu() {
        Minecraft client = Minecraft.getInstance();
        if (client.screen instanceof ModConfigScreen) {
            return false;
        }
        return client.level == null && client.player == null;
    }

    public static boolean isValidScreen(Screen screen) {
        return !BLOCKED_SCREEN_CLASSES.contains(screen.getClass()) && !BLOCKED_SCREEN_NAMES.contains(screen.getClass().getSimpleName());
    }

    public static void push() {
        if (graphics == null) {
            return;
        }
        if (!ModConfig.getConfig().enableAnimation || SmoothGui.isInMainMenu()) {
            return;
        }
        appliedDisplacement = SmoothGui.calculateDisplacement();
        graphics.pose().translate(0.0f, -appliedDisplacement, 0.0f);
    }

    public static void pop() {
        if (graphics == null) {
            return;
        }
        if (appliedDisplacement == 0.0f) {
            return;
        }
        graphics.pose().translate(0.0f, appliedDisplacement, 0.0f);
        appliedDisplacement = 0.0f;
    }

    public static void push(GuiGraphics graphics) {
        SmoothGui.graphics = graphics;
        SmoothGui.push();
    }

    public static void pop(GuiGraphics graphics) {
        SmoothGui.graphics = graphics;
        SmoothGui.pop();
    }
}

