/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.smoothgui.config;

import com.ezzenix.smoothgui.config.AnimationDirection;
import com.ezzenix.smoothgui.config.AnimationStyle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ModConfig {
    private static ModConfig instance;
    private static final Gson GSON;
    private transient File configFile;
    public boolean enableAnimation = true;
    public int animationTime = 220;
    public double animationScale = 1.0;
    public boolean fadeBackground = true;
    public AnimationStyle animationStyle = AnimationStyle.BACK;
    public AnimationDirection animationDirection = AnimationDirection.DOWN;

    public static ModConfig getConfig() {
        if (instance == null) {
            instance = new ModConfig();
        }
        return instance;
    }

    public void load(File configFile) {
        this.configFile = configFile;
        if (!configFile.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            instance = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            ModConfig.instance.configFile = configFile;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        if (this.configFile == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        this.enableAnimation = true;
        this.animationTime = 220;
        this.animationScale = 1.0;
        this.fadeBackground = true;
        this.animationStyle = AnimationStyle.BACK;
        this.animationDirection = AnimationDirection.DOWN;
    }

    static {
        GSON = new GsonBuilder().registerTypeAdapter(AnimationDirection.class, (json, type, context) -> {
            try {
                return AnimationDirection.valueOf(json.getAsString());
            }
            catch (IllegalArgumentException e) {
                return AnimationDirection.DOWN;
            }
        }).registerTypeAdapter(AnimationStyle.class, (json, type, context) -> {
            try {
                return AnimationStyle.valueOf(json.getAsString());
            }
            catch (IllegalArgumentException e) {
                return AnimationStyle.BACK;
            }
        }).setPrettyPrinting().create();
    }
}

