/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.smoothgui.mixin;

import com.ezzenix.smoothgui.SmoothGui;
import com.ezzenix.smoothgui.config.ModConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Screen.class})
public class ScreenMixin {
    @Unique
    private static final int COLOR_TOP = -1072689136;
    @Unique
    private static final int COLOR_BOTTOM = -804253680;

    @Inject(method={"renderWithTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.BEFORE)})
    private void screenRender(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        if (!SmoothGui.isValidScreen((Screen)this)) {
            return;
        }
        SmoothGui.push(guiGraphics);
    }

    @Inject(method={"renderWithTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)})
    private void screenRenderEnd(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        SmoothGui.pop(guiGraphics);
    }

    @Inject(method={"renderMenuBackground(Lnet/minecraft/client/gui/GuiGraphics;IIII)V"}, at={@At(value="HEAD")})
    private void onRenderMenuBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, CallbackInfo ci) {
        SmoothGui.pop(guiGraphics);
    }

    @Inject(method={"renderMenuBackground(Lnet/minecraft/client/gui/GuiGraphics;IIII)V"}, at={@At(value="TAIL")})
    private void onRenderMenuBackgroundEnd(GuiGraphics guiGraphics, int x, int y, int width, int height, CallbackInfo ci) {
        if (!SmoothGui.isValidScreen((Screen)this)) {
            return;
        }
        SmoothGui.push(guiGraphics);
    }

    @Unique
    private int applyFade(int color, float fade) {
        int a = (int)((float)(color >> 24 & 0xFF) * fade);
        return a << 24 | color & 0xFFFFFF;
    }

    @Inject(method={"renderTransparentBackground"}, at={@At(value="HEAD")}, cancellable=true)
    public void onRenderTransparentBackground(GuiGraphics guiGraphics, CallbackInfo ci) {
        if (!SmoothGui.isValidScreen((Screen)this)) {
            return;
        }
        ci.cancel();
        Screen screen = (Screen)this;
        SmoothGui.pop(guiGraphics);
        if (!ModConfig.getConfig().fadeBackground) {
            guiGraphics.fillGradient(0, 0, screen.width, screen.height, -1072689136, -804253680);
        } else {
            float fade = Math.min(SmoothGui.getAlphaSince(SmoothGui.lastScreenOpenedTime) * 2.6f, 1.0f);
            int top = this.applyFade(-1072689136, fade);
            int bottom = this.applyFade(-804253680, fade);
            guiGraphics.fillGradient(0, 0, screen.width, screen.height, top, bottom);
        }
        SmoothGui.push(guiGraphics);
    }
}

