/*
 * Decompiled with CFR 0.152.
 */
package moonfather.not_interested.messaging.client_to_server;

import moonfather.not_interested.messaging.client_to_server.BuggerOffMessage;
import moonfather.not_interested.mixin.MenuAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ButtonClickHandler {
    public static void handleClientRequest(BuggerOffMessage msg, IPayloadContext context) {
        try {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ButtonClickHandler.sendTheTraderAway(sp);
            }
        }
        catch (Exception e) {
            context.disconnect((Component)Component.literal((String)("Networking error in NI mod\n" + e.getMessage())));
        }
    }

    private static void sendTheTraderAway(ServerPlayer player) {
        MerchantMenu menu;
        Merchant merchant;
        assert (player != null);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof MerchantMenu && (merchant = ((MenuAccessor)(menu = (MerchantMenu)abstractContainerMenu)).getTraderField()) instanceof WanderingTrader) {
            WanderingTrader wt = (WanderingTrader)merchant;
            player.closeContainer();
            BlockPos target = BlockPos.ZERO;
            boolean havePlayerTarget = false;
            for (Player otherPlayer : wt.level().players()) {
                double distance;
                if (!EntitySelector.NO_SPECTATORS.test(otherPlayer) || !EntitySelector.LIVING_ENTITY_STILL_ALIVE.test(otherPlayer) || !((distance = otherPlayer.distanceToSqr((Entity)player)) > 40.0) || !(distance < 240.0)) continue;
                target = otherPlayer.blockPosition();
                havePlayerTarget = true;
                break;
            }
            if (!havePlayerTarget) {
                int x = wt.blockPosition().getX() + 33 * (wt.level().random.nextInt(3) - 1);
                int z = wt.blockPosition().getZ() + 33 * (wt.level().random.nextInt(3) - 1);
                int y = wt.level().getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
                target = new BlockPos(x, y, z);
            }
            wt.setDespawnDelay(200);
            wt.setWanderTarget(target);
            wt.setHomeTo(target, 8);
        }
    }
}

