/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerSessionManager {
    private static final Map<UUID, ItemStack[]> savedInventories = new HashMap<UUID, ItemStack[]>();
    private static final Map<UUID, Location> savedLocations = new HashMap<UUID, Location>();

    public static void saveInventory(Player player) {
        savedInventories.put(player.getUniqueId(), player.getInventory().getContents());
    }

    public static void restoreInventory(Player player) {
        ItemStack[] contents = savedInventories.get(player.getUniqueId());
        if (contents != null) {
            player.getInventory().setContents(contents);
        }
    }

    public static void saveLocation(Player player) {
        savedLocations.put(player.getUniqueId(), player.getLocation().clone());
    }

    public static void restoreLocation(Player player) {
        Location loc = savedLocations.get(player.getUniqueId());
        if (loc != null) {
            player.teleport(loc);
        }
    }

    public static void clearPlayerData() {
        savedInventories.clear();
        savedLocations.clear();
    }
}

