/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.eisutils.builder;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.builder.StringBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class RecipeInventory
implements InventoryHolder {
    private final Material material;
    private final List<Material[]> list = new ArrayList<Material[]>();
    private IChatBaseComponent notFoundMessage = ((IChatMutableComponent)CraftChatMessage.fromStringOrEmpty((String)Prefix.SERVER)).b((IChatBaseComponent)IChatBaseComponent.a((String)"bingo.item.recipe.not.found", (String)"Recipe not found!").a(EnumChatFormat.m));

    public RecipeInventory(Material material) {
        this.material = material;
        List recipe = Bukkit.getRecipesFor((ItemStack)new ItemStack(material));
        recipe.forEach(recipe1 -> {
            if (recipe1 instanceof ShapedRecipe) {
                ShapedRecipe shaped = (ShapedRecipe)recipe1;
                Set entries = shaped.getChoiceMap().entrySet();
                for (Map.Entry entry : entries) {
                    String s;
                    Material[] stacks;
                    Object patt0$temp = entry.getValue();
                    if (patt0$temp instanceof RecipeChoice.MaterialChoice) {
                        RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)patt0$temp;
                        for (Material m : materialChoice.getChoices()) {
                            stacks = new Material[9];
                            s = String.join((CharSequence)"", shaped.getShape());
                            int[] slots = IntStream.rangeClosed(0, 8).filter(value -> {
                                int row = Math.floorDiv(value, 3);
                                int column = value % 3;
                                if (shaped.getShape().length <= row) {
                                    return false;
                                }
                                return shaped.getShape()[row].length() > column;
                            }).toArray();
                            for (int i = 0; i < s.length(); ++i) {
                                Material current;
                                ItemStack item = (ItemStack)shaped.getIngredientMap().get(Character.valueOf(s.charAt(i)));
                                Material material = current = item == null ? Material.AIR : item.getType();
                                if (current == materialChoice.getItemStack().getType()) {
                                    current = m;
                                }
                                stacks[slots[i]] = current;
                            }
                            this.list.add(stacks);
                        }
                        continue;
                    }
                    Object patt1$temp = entry.getValue();
                    if (!(patt1$temp instanceof RecipeChoice.ExactChoice)) continue;
                    RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)patt1$temp;
                    for (ItemStack itemStack : exactChoice.getChoices()) {
                        if (itemStack == null) continue;
                        stacks = new Material[9];
                        s = String.join((CharSequence)"", shaped.getShape());
                        for (int i = 0; i < s.length(); ++i) {
                            Material current;
                            ItemStack item = (ItemStack)shaped.getIngredientMap().get(Character.valueOf(s.charAt(i)));
                            Material material = current = item == null ? Material.AIR : item.getType();
                            if (current == exactChoice.getItemStack().getType()) {
                                current = itemStack.getType();
                            }
                            stacks[i] = current;
                        }
                        this.list.add(stacks);
                    }
                }
            } else if (recipe1 instanceof ShapelessRecipe) {
                ShapelessRecipe shapeless = (ShapelessRecipe)recipe1;
                for (RecipeChoice choice : shapeless.getChoiceList()) {
                    Material current;
                    ArrayList<Material> stacks;
                    if (choice instanceof RecipeChoice.MaterialChoice) {
                        RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)choice;
                        for (Material m : materialChoice.getChoices()) {
                            stacks = new ArrayList<Material>();
                            for (ItemStack i : shapeless.getIngredientList()) {
                                if (i == null) continue;
                                current = i.getType();
                                if (current == materialChoice.getItemStack().getType()) {
                                    current = m;
                                }
                                stacks.add(current);
                            }
                            while (stacks.size() != 9) {
                                stacks.add(Material.AIR);
                            }
                            this.list.add(stacks.toArray(new Material[9]));
                        }
                        continue;
                    }
                    if (!(choice instanceof RecipeChoice.ExactChoice)) continue;
                    RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)choice;
                    for (ItemStack itemStack : exactChoice.getChoices()) {
                        if (itemStack == null) continue;
                        stacks = new ArrayList();
                        for (ItemStack i : shapeless.getIngredientList()) {
                            if (i == null) continue;
                            current = i.getType();
                            if (current == exactChoice.getItemStack().getType()) {
                                current = itemStack.getType();
                            }
                            stacks.add(current);
                        }
                        while (stacks.size() != 9) {
                            stacks.add(Material.AIR);
                        }
                        this.list.add(stacks.toArray(new Material[9]));
                    }
                }
            } else if (recipe1 instanceof FurnaceRecipe) {
                FurnaceRecipe furnace = (FurnaceRecipe)recipe1;
                RecipeChoice patt0$temp = furnace.getInputChoice();
                if (patt0$temp instanceof RecipeChoice.MaterialChoice) {
                    RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)patt0$temp;
                    if (!materialChoice.getChoices().isEmpty()) {
                        materialChoice.getChoices().forEach(material1 -> this.list.add(new Material[]{material1}));
                    } else {
                        this.list.add(new Material[]{materialChoice.getItemStack().getType()});
                    }
                } else {
                    RecipeChoice patt1$temp = furnace.getInputChoice();
                    if (patt1$temp instanceof RecipeChoice.ExactChoice) {
                        RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)patt1$temp;
                        if (!exactChoice.getChoices().isEmpty()) {
                            exactChoice.getChoices().forEach(material1 -> this.list.add(new Material[]{material1.getType()}));
                        } else {
                            this.list.add(new Material[]{exactChoice.getItemStack().getType()});
                        }
                    }
                }
            } else if (recipe1 instanceof SmithingRecipe) {
                SmithingRecipe smithing = (SmithingRecipe)recipe1;
                ArrayList<Material> firstChoice = new ArrayList<Material>();
                RecipeChoice patt0$temp = smithing.getBase();
                if (patt0$temp instanceof RecipeChoice.MaterialChoice) {
                    RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)patt0$temp;
                    if (!materialChoice.getChoices().isEmpty()) {
                        firstChoice.addAll(materialChoice.getChoices());
                    } else {
                        firstChoice.add(materialChoice.getItemStack().getType());
                    }
                } else {
                    RecipeChoice patt1$temp = smithing.getBase();
                    if (patt1$temp instanceof RecipeChoice.ExactChoice) {
                        RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)patt1$temp;
                        if (!exactChoice.getChoices().isEmpty()) {
                            firstChoice.addAll(exactChoice.getChoices().stream().map(ItemStack::getType).toList());
                        } else {
                            firstChoice.add(exactChoice.getItemStack().getType());
                        }
                    }
                }
                ArrayList<Material> secondChoice = new ArrayList<Material>();
                RecipeChoice patt2$temp = smithing.getAddition();
                if (patt2$temp instanceof RecipeChoice.MaterialChoice) {
                    RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)patt2$temp;
                    if (!materialChoice.getChoices().isEmpty()) {
                        secondChoice.addAll(materialChoice.getChoices());
                    } else {
                        secondChoice.add(materialChoice.getItemStack().getType());
                    }
                } else {
                    RecipeChoice patt3$temp = smithing.getAddition();
                    if (patt3$temp instanceof RecipeChoice.ExactChoice) {
                        RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)patt3$temp;
                        if (!exactChoice.getChoices().isEmpty()) {
                            secondChoice.addAll(exactChoice.getChoices().stream().map(ItemStack::getType).toList());
                        } else {
                            secondChoice.add(exactChoice.getItemStack().getType());
                        }
                    }
                }
                this.list.addAll(this.combineLists(firstChoice, secondChoice));
            }
        });
    }

    public IChatBaseComponent getNotFoundMessage() {
        return this.notFoundMessage;
    }

    public RecipeInventory setNotFoundMessage(IChatBaseComponent message) {
        this.notFoundMessage = message;
        return this;
    }

    public List<Material[]> combineLists(List<Material> list1, List<Material> list2) {
        ArrayList<Material[]> combinedList = new ArrayList<Material[]>();
        Random random = new Random();
        int maxSize = Math.max(list1.size(), list2.size());
        for (int i = 0; i < maxSize; ++i) {
            Material item1 = i < list1.size() ? list1.get(i) : list1.get(random.nextInt(list1.size()));
            Material item2 = i < list2.size() ? list2.get(i) : list2.get(random.nextInt(list2.size()));
            combinedList.add(new Material[]{item1, item2});
        }
        return combinedList;
    }

    public boolean isCraftable() {
        return !this.list.isEmpty();
    }

    public boolean open(final Player player) {
        if (this.list.isEmpty()) {
            return false;
        }
        this.createInventory(0).openAsNMS((HumanEntity)player, this.getTitle());
        new BukkitRunnable(){
            int index = 0;

            public void run() {
                if (this.index >= RecipeInventory.this.list.size()) {
                    this.index = 0;
                }
                if (player.getOpenInventory() == null || player.getOpenInventory().getTopInventory() == null || player.getOpenInventory().getTopInventory().getHolder() == null || !player.getOpenInventory().getTopInventory().getHolder().equals((Object)RecipeInventory.this)) {
                    this.cancel();
                } else {
                    RecipeInventory.this.createInventory(this.index++).openAsNMS((HumanEntity)player, RecipeInventory.this.getTitle());
                }
            }
        }.runTaskTimer(Main.plugin, 0L, 20L);
        return true;
    }

    private InventoryBuilder createInventory(int index) {
        Material[] current = this.list.get(index);
        if (current.length == 9) {
            InventoryBuilder builder = new InventoryBuilder((InventoryHolder)this, InventoryType.WORKBENCH, new StringBuilder(this.material.name()).toNormalCase().build());
            builder.setItem(0, this.material);
            for (int i = 1; i <= current.length; ++i) {
                if (current[i - 1] == null || current[i - 1] == Material.AIR) continue;
                ItemBuilder itemBuilder = new ItemBuilder(current[i - 1]);
                itemBuilder.setClickHandler(event -> {
                    if (!new RecipeInventory(event.getCurrentItem().getType()).setNotFoundMessage(this.notFoundMessage).open((Player)event.getWhoClicked())) {
                        BingoUtils.sendMessage(event.getWhoClicked(), this.notFoundMessage, true);
                    }
                });
                builder.setItem(i, itemBuilder.build());
            }
            return builder;
        }
        if (current.length == 2) {
            InventoryBuilder builder = new InventoryBuilder((InventoryHolder)this, InventoryType.SMITHING, new StringBuilder(this.material.name()).toNormalCase().build());
            builder.setItem(3, this.material);
            for (int i = 1; i <= current.length; ++i) {
                ItemBuilder itemBuilder = new ItemBuilder(current[i - 1]);
                if (current[i - 1] != Material.AIR) {
                    itemBuilder.setClickHandler(event -> {
                        if (!new RecipeInventory(event.getCurrentItem().getType()).setNotFoundMessage(this.notFoundMessage).open((Player)event.getWhoClicked())) {
                            BingoUtils.sendMessage(event.getWhoClicked(), this.notFoundMessage, true);
                        }
                    });
                }
                builder.setItem(i, itemBuilder.build());
            }
            return builder;
        }
        if (current.length == 1) {
            InventoryBuilder builder = new InventoryBuilder((InventoryHolder)this, InventoryType.FURNACE, new StringBuilder(this.material.name()).toNormalCase().build());
            builder.setItem(2, this.material);
            ItemBuilder itemBuilder = new ItemBuilder(current[0]);
            if (current[0] != Material.AIR) {
                itemBuilder.setClickHandler(event -> {
                    if (!new RecipeInventory(event.getCurrentItem().getType()).setNotFoundMessage(this.notFoundMessage).open((Player)event.getWhoClicked())) {
                        BingoUtils.sendMessage(event.getWhoClicked(), this.notFoundMessage, true);
                    }
                });
            }
            builder.setItem(0, itemBuilder.build());
            builder.setItem(1, new ItemBuilder(Material.COAL).build());
            return builder;
        }
        return null;
    }

    private IChatBaseComponent getTitle() {
        return IChatBaseComponent.a((String)this.material.getTranslationKey(), (String)new StringBuilder(this.material.name()).toNormalCase().build());
    }

    @NotNull
    public Inventory getInventory() {
        return this.createInventory(0).build();
    }
}

