/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.PlayerPerTeamSetting;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.ColorConverter;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.builder.NMSScoreboardBuilder;
import de.eisi05.bingo.utils.eisutils.builder.RecipeInventory;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BingoTeam {
    public static final List<BingoTeam> teams = new ArrayList<BingoTeam>();
    private final int id;
    private final ChatColor color;
    private final Set<UUID> players = new HashSet<UUID>();
    private final List<BingoObject<?>> collectedObjects = new ArrayList();
    private final List<AdvancementProgress> advancementProgresses = new ArrayList<AdvancementProgress>();
    private final Inventory backpack;

    private BingoTeam(int id, ChatColor color) {
        this.id = id;
        this.color = color;
        this.backpack = Bukkit.createInventory(null, (int)27, (String)("Backpack >> " + String.valueOf(this.getName())));
        teams.add(this);
    }

    public static Optional<BingoTeam> getTeam(UUID player) {
        for (BingoTeam team : teams) {
            if (!team.getPlayers().contains(player)) continue;
            return Optional.of(team);
        }
        return Optional.empty();
    }

    public static void createBingoTeams() {
        ArrayList<ChatColor> colors = new ArrayList<ChatColor>(List.of(BingoUtils.teamColors));
        for (int i = 0; i < 9; ++i) {
            new BingoTeam(i + 1, (ChatColor)colors.remove(new Random().nextInt(colors.size())));
        }
    }

    public static InventoryBuilder getSelectionInventory(Player player) {
        LinkedList<BingoTeam> sorted = BingoTeam.getSortedTeams();
        int invSize = sorted.size() % 9 == 0 ? sorted.size() : (sorted.size() / 9 + 1) * 9;
        InventoryBuilder inventoryBuilder = new InventoryBuilder((InventoryHolder)new BingoTeamInventoryHolder(), invSize, "Team Selection");
        for (int i = 0; i < sorted.size(); ++i) {
            BingoTeam current = (BingoTeam)sorted.get(i);
            inventoryBuilder.setItem(i, current.getIcon().setEnchantmentGlint(current.players.contains(player.getUniqueId())).setClickHandler(event -> {
                if (current.isFull()) {
                    BingoUtils.sendMessage(event.getWhoClicked(), (IChatBaseComponent)IChatBaseComponent.a((String)"team.full", (String)"This team is full!").a(EnumChatFormat.m), true);
                    ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
                    return;
                }
                BingoTeam.getTeam(event.getWhoClicked().getUniqueId()).ifPresent(team -> team.removePlayer(event.getWhoClicked()));
                current.addPlayer(event.getWhoClicked());
                event.getWhoClicked().closeInventory();
                BingoTeam.updateInventory();
                BingoUtils.sendMessage(event.getWhoClicked(), (IChatBaseComponent)IChatBaseComponent.a((String)"team.joined", (String)("You joined team " + CraftChatMessage.fromComponent((IChatBaseComponent)current.getName())), (Object[])new Object[]{current.getName()}).a(EnumChatFormat.h), true);
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            }).build());
        }
        return inventoryBuilder.normal();
    }

    private static void updateInventory() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getOpenInventory() == null) continue;
            if (player.getOpenInventory().getTopInventory() == null) {
                return;
            }
            if (player.getOpenInventory().getTopInventory().getHolder() == null) {
                return;
            }
            if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof BingoTeamInventoryHolder)) continue;
            BingoTeam.getSelectionInventory(player).openAsNMS((HumanEntity)player, (IChatBaseComponent)IChatBaseComponent.a((String)"options.teamSelection.title", (String)"Team Selection"));
        }
    }

    public static LinkedList<BingoTeam> getSortedTeams() {
        return new LinkedList<BingoTeam>(teams.stream().sorted(Comparator.comparingInt(value -> value.id)).toList());
    }

    public static void addPlayerToSpectator(HumanEntity player) {
        Bukkit.getOnlinePlayers().forEach(online -> new NMSScoreboardBuilder((Player)online).addPlayerToTeamByEntry((OfflinePlayer)((Player)player), "team0"));
    }

    public int getId() {
        return this.id;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public IChatMutableComponent getName() {
        return BingoUtils.createComponent(this.getNameAsString());
    }

    public String getNameAsString() {
        return String.valueOf(this.color) + "#" + this.id;
    }

    public Inventory getBackpack() {
        return this.backpack;
    }

    public ItemBuilder getIcon() {
        ItemBuilder itemBuilder = new ItemBuilder(Material.valueOf((String)(ColorConverter.getColor(this.color).name() + "_BED"))).setName((IChatBaseComponent)this.getName());
        ArrayList<IChatMutableComponent> lore = new ArrayList<IChatMutableComponent>();
        for (UUID uuid : this.players) {
            lore.add(IChatBaseComponent.b((String)Bukkit.getPlayer((UUID)uuid).getName()).a(style -> style.a(EnumChatFormat.h).b(Boolean.valueOf(false))));
        }
        for (int i = lore.size(); i < (Integer)BingoSetting.getSetting(PlayerPerTeamSetting.class).getValue(); ++i) {
            lore.add(IChatBaseComponent.b((String)" --- ").a(style -> style.a(EnumChatFormat.h).b(Boolean.valueOf(false))));
        }
        return itemBuilder.setLore(lore.toArray(new IChatBaseComponent[0]));
    }

    public boolean isFull() {
        return this.players.size() == ((Integer)BingoSetting.getSetting(PlayerPerTeamSetting.class).getValue()).intValue();
    }

    public void addPlayer(HumanEntity player) {
        this.players.add(player.getUniqueId());
        Bukkit.getOnlinePlayers().forEach(online -> new NMSScoreboardBuilder((Player)online).addPlayerToTeam((OfflinePlayer)((Player)player), this.getNameAsString()));
    }

    public void removePlayer(HumanEntity player) {
        this.players.remove(player.getUniqueId());
        Bukkit.getOnlinePlayers().forEach(online -> new NMSScoreboardBuilder((Player)online).removePlayerFromTeam((OfflinePlayer)((Player)player), this.getNameAsString()));
    }

    public void foundBingoItem(BingoObject<?> bingoObject) {
        this.collectedObjects.add(bingoObject);
    }

    public Set<BingoObject<?>> getMissingBingoItems() {
        return BingoObject.getSelectedObjects().stream().filter(bingoObject -> !this.collectedObjects.contains(bingoObject)).collect(Collectors.toSet());
    }

    public void updateAdvancementProgresses() {
        this.getPlayers().stream().map(Bukkit::getOfflinePlayer).filter(OfflinePlayer::isOnline).forEach(player -> BingoObject.getBingoObjects(BingoObject.BingoAdvancement.class).forEach(bingoAdvancement -> {
            AdvancementProgress progress = player.getPlayer().getAdvancementProgress((Advancement)bingoAdvancement.getObject());
            this.advancementProgresses.stream().filter(advancementProgress -> advancementProgress.getAdvancement().equals((Object)progress.getAdvancement())).findFirst().ifPresentOrElse(advancementProgress -> {
                if (advancementProgress.getAwardedCriteria().size() > progress.getAwardedCriteria().size()) {
                    advancementProgress.getAwardedCriteria().forEach(arg_0 -> ((AdvancementProgress)progress).awardCriteria(arg_0));
                } else if (advancementProgress.getAwardedCriteria().size() < progress.getAwardedCriteria().size()) {
                    progress.getAwardedCriteria().forEach(arg_0 -> ((AdvancementProgress)advancementProgress).awardCriteria(arg_0));
                }
            }, () -> this.advancementProgresses.add(progress));
        }));
    }

    public LinkedList<ItemStack> getBingoItems() {
        return BingoObject.getSelectedObjects().stream().map(this::lambda$getBingoItems$18).collect(Collectors.toCollection(LinkedList::new));
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ ItemStack lambda$getBingoItems$18(BingoObject bingoObject) {
        if (bingoObject.hasFound(this)) {
            return new ItemBuilder(Material.LIME_STAINED_GLASS_PANE).setEnchantmentGlint(true).setName(bingoObject.asDisplayIcon().getItemMeta().getDisplayName()).clearAttributes().hideToolTip().build();
        }
        preLore = null;
        if (bingoObject instanceof BingoObject.BingoAdvancement) {
            bingoAdvancement = (BingoObject.BingoAdvancement)bingoObject;
            preLore = IChatBaseComponent.a((String)("advancements." + ((Advancement)bingoAdvancement.object).getKey().getKey().replace("/", ".") + ".description"), (String)((Advancement)bingoAdvancement.object).getDisplay().getDescription());
        }
        v0 = IChatBaseComponent.b((String)"> ").b((IChatBaseComponent)BingoObject.getName(bingoObject.getClass())).a(EnumChatFormat.h);
        if (!(bingoObject instanceof BingoObject.BingoAdvancement)) ** GOTO lbl-1000
        bingoAdvancement = (BingoObject.BingoAdvancement)bingoObject;
        if (((Advancement)bingoAdvancement.object).getCriteria().size() > 1) {
            v1 = " (" + String.valueOf(this.advancementProgresses.stream().filter((Predicate<AdvancementProgress>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBingoItems$14(de.eisi05.bingo.bingo.BingoObject$BingoAdvancement org.bukkit.advancement.AdvancementProgress ), (Lorg/bukkit/advancement/AdvancementProgress;)Z)((BingoObject.BingoAdvancement)bingoAdvancement)).map((Function<AdvancementProgress, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBingoItems$15(org.bukkit.advancement.AdvancementProgress ), (Lorg/bukkit/advancement/AdvancementProgress;)Ljava/lang/Integer;)()).findFirst().orElse(0)) + "/" + ((Advancement)bingoAdvancement.object).getCriteria().size() + ")";
        } else lbl-1000:
        // 2 sources

        {
            v1 = "";
        }
        v2 = IChatBaseComponent.b((String)v1);
        if (bingoObject instanceof BingoObject.BingoItem) {
            bingoItem = (BingoObject.BingoItem)bingoObject;
            v3 = new RecipeInventory(((ItemStack)bingoItem.object).getType()).isCraftable() ? IChatBaseComponent.b((String)" (").a((UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBingoItems$16(net.minecraft.network.chat.ChatModifier ), (Lnet/minecraft/network/chat/ChatModifier;)Lnet/minecraft/network/chat/ChatModifier;)()).b((IChatBaseComponent)IChatBaseComponent.a((String)"bingo.item.recipe.found", (String)"Click to view Recipe")).b((IChatBaseComponent)IChatBaseComponent.b((String)")")) : IChatBaseComponent.i();
        } else {
            v3 = IChatBaseComponent.i();
        }
        lore = v0.b((IChatBaseComponent)v2.b((IChatBaseComponent)v3));
        v4 = new ItemBuilder(bingoObject.asDisplayIcon());
        if (preLore == null) {
            v5 = new IChatBaseComponent[1];
            v6 = v5;
            v5[0] = lore;
        } else {
            v7 = new IChatBaseComponent[3];
            v7[0] = preLore;
            v7[1] = IChatBaseComponent.i();
            v6 = v7;
            v7[2] = lore;
        }
        return v4.setLore(v6).setClickHandler((Consumer<InventoryClickEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getBingoItems$17(org.bukkit.event.inventory.InventoryClickEvent ), (Lorg/bukkit/event/inventory/InventoryClickEvent;)V)()).build();
    }

    private static /* synthetic */ void lambda$getBingoItems$17(InventoryClickEvent event) {
        IChatMutableComponent message = IChatBaseComponent.a((String)"bingo.item.recipe.none", (String)"Item cannot be crafted!").a(EnumChatFormat.m);
        if (!new RecipeInventory(event.getCurrentItem().getType()).setNotFoundMessage((IChatBaseComponent)message).open((Player)event.getWhoClicked())) {
            BingoUtils.sendMessage(event.getWhoClicked(), (IChatBaseComponent)message, true);
        }
    }

    private static /* synthetic */ ChatModifier lambda$getBingoItems$16(ChatModifier style) {
        return style.a(EnumChatFormat.h).b(Boolean.valueOf(true));
    }

    private static /* synthetic */ Integer lambda$getBingoItems$15(AdvancementProgress advancementProgress) {
        return advancementProgress.getAwardedCriteria().size();
    }

    private static /* synthetic */ boolean lambda$getBingoItems$14(BingoObject.BingoAdvancement bingoAdvancement, AdvancementProgress advancementProgress) {
        return advancementProgress.getAdvancement().equals(bingoAdvancement.object);
    }

    public static class BingoTeamInventoryHolder
    implements InventoryHolder {
        @NotNull
        public Inventory getInventory() {
            return null;
        }
    }
}

