/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.listener.SettingsListener;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.lang.Translation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class ObjectTypesSetting
extends BingoSetting<List<Class<? extends BingoObject<?>>>> {
    private int cursorIndex = 0;

    ObjectTypesSetting() {
    }

    @Override
    public List<Class<? extends BingoObject<?>>> getDefaultValue() {
        return Arrays.stream(BingoObject.getClasses()).toList();
    }

    @Override
    public ItemBuilder getIcon() {
        return new ItemBuilder(Material.WRITABLE_BOOK).setName((IChatBaseComponent)IChatBaseComponent.a((String)"options.objectTypes.title", (String)"Object Types").a(style -> style.a(EnumChatFormat.o).b(Boolean.valueOf(false)))).setLore(this.getLore(this.cursorIndex).toArray(new IChatBaseComponent[0])).addLore(this.getDescription(true)).setClickHandler(event -> {
            if (event.getClick().isLeftClick()) {
                this.cursorIndex = (this.cursorIndex + 1) % BingoObject.getClasses().length;
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 100.0f, 1.5f);
            } else {
                Class<BingoObject<?>> selectedValue;
                ArrayList currentValues = new ArrayList((Collection)this.getValue());
                if (currentValues.contains(selectedValue = BingoObject.getClasses()[this.cursorIndex])) {
                    currentValues.remove(selectedValue);
                } else {
                    currentValues.add(selectedValue);
                }
                this.setValue(currentValues);
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            }
            ItemStack currentItem = event.getCurrentItem();
            currentItem.setItemMeta(ItemBuilder.setLore(currentItem, Stream.concat(this.getLore(this.cursorIndex).stream(), Arrays.stream(this.getDescription(true))).toList()).getItemMeta());
            SettingsListener.updateInventory(event);
        });
    }

    private List<IChatBaseComponent> getLore(int cursorIndex) {
        ArrayList<IChatMutableComponent> lore = new ArrayList<IChatMutableComponent>(Arrays.stream(BingoObject.getClasses()).map(aClass -> BingoObject.getName(aClass).a(style -> style.a(EnumChatFormat.j)).b((IChatBaseComponent)IChatBaseComponent.b((String)" - ").a(style -> style.a(EnumChatFormat.h)).b(((List)this.getValue()).contains(aClass) ? Translation.ENABLED : Translation.DISABLED))).toList());
        lore.set(cursorIndex, IChatBaseComponent.b((String)"> ").a(style -> style.a(EnumChatFormat.h)).b((IChatBaseComponent)lore.get(cursorIndex)));
        return lore;
    }

    @Override
    public IChatBaseComponent getSettingsText() {
        IChatMutableComponent component = IChatBaseComponent.a((String)"options.objectTypes.title", (String)"Object Types").a(style -> style.a(EnumChatFormat.h).b(Boolean.valueOf(false))).b((IChatBaseComponent)IChatBaseComponent.b((String)": "));
        List classes = (List)this.getValue();
        for (int i = 0; i < classes.size(); ++i) {
            if (i != 0) {
                component = component.b((IChatBaseComponent)IChatBaseComponent.b((String)", ").a(style -> style.a(EnumChatFormat.h)));
            }
            component = component.b((IChatBaseComponent)BingoObject.getName((Class)classes.get(i)).a(style -> style.a(EnumChatFormat.j)));
        }
        return component;
    }

    @Override
    public int getSlot() {
        return 42;
    }

    @Override
    public List<Triple<String, String, Boolean>> getDescriptionKeys() {
        return List.of(Triple.of((Object)"options.objectTypes.description.1", (Object)"Which Object Types should be used for the game", (Object)false), Triple.of((Object)"options.objectTypes.description.2", (Object)"Left-click -> Cycle trough the types", (Object)true), Triple.of((Object)"options.objectTypes.description.3", (Object)"Right-click -> Change the value", (Object)true));
    }

    @Override
    public List<Class<? extends BingoObject<?>>> deserialize(Object o) {
        List<Class<? extends BingoObject<?>>> classes = ((List)o).stream().map(s -> {
            try {
                return Class.forName(s);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }).filter(Objects::nonNull).toList();
        return classes;
    }

    @Override
    public Object serialize(List<Class<? extends BingoObject<?>>> classes) {
        return classes.stream().map(Class::getName).toList();
    }
}

