/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.executors.CommandArguments;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;

public class AsyncOfflinePlayerArgument
extends SafeOverrideableArgument<CompletableFuture<OfflinePlayer>, OfflinePlayer> {
    public AsyncOfflinePlayerArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentProfile(), OfflinePlayer::getName);
    }

    @Override
    public Class<CompletableFuture<OfflinePlayer>> getPrimitiveType() {
        return CompletableFuture.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ASYNC_OFFLINE_PLAYER;
    }

    @Override
    public <CommandSourceStack> CompletableFuture<OfflinePlayer> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CommandAPIBukkit.get().getOfflinePlayer(cmdCtx, key);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

