/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.commands;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.commands.AbstractCommand;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ScrollInventory;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.CommandArguments;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public non-sealed class BingoCommand
extends AbstractCommand
implements InventoryHolder {
    public BingoCommand() {
        super("bingo", "command.bingo.description", "Opens the bingo board");
        this.withPermission("bingo");
        this.withFullDescription("Opens the bingo board");
        this.executesPlayer((Player player, CommandArguments args) -> {
            if (GameState.currentGameState != GameState.INGAME) {
                BingoUtils.sendMessage((HumanEntity)player, (IChatBaseComponent)IChatBaseComponent.b((String)"There is no game running!").a(EnumChatFormat.m), true);
                return;
            }
            player.openInventory(this.getBingoInventory(BingoTeam.getTeam(player.getUniqueId()).orElse(null)));
        });
        ((CommandAPICommand)this.withOptionalArguments(new Argument[]{(Argument)((Argument)new StringArgument("team").withRequirement(commandSender -> {
            Player player;
            return commandSender instanceof Player && BingoTeam.getTeam((player = (Player)commandSender).getUniqueId()).isEmpty();
        })).replaceSuggestions(ArgumentSuggestions.stringsAsync(commandSenderSuggestionInfo -> CompletableFuture.supplyAsync(() -> (String[])BingoTeam.teams.stream().map(team -> "#" + team.getId()).toArray(String[]::new))))})).executesPlayer((Player sender, CommandArguments args) -> {
            if (GameState.currentGameState != GameState.INGAME) {
                BingoUtils.sendMessage((HumanEntity)sender, (IChatBaseComponent)IChatBaseComponent.b((String)"There is no game running!").a(EnumChatFormat.m), true);
                return;
            }
            Optional<BingoTeam> team = BingoTeam.getTeam(sender.getUniqueId());
            team.ifPresentOrElse(team1 -> sender.openInventory(this.getBingoInventory((BingoTeam)team1)), () -> {
                String current = args.getRaw("team");
                BingoTeam.teams.stream().filter(team1 -> ("#" + team1.getId()).equals(current)).findFirst().ifPresentOrElse(team1 -> sender.openInventory(this.getBingoInventory((BingoTeam)team1)), () -> BingoUtils.sendMessage((HumanEntity)sender, (IChatBaseComponent)IChatBaseComponent.b((String)"There is no such team!").a(EnumChatFormat.m), true));
            });
        });
        this.register();
    }

    private Inventory getBingoInventory(@Nullable BingoTeam team) {
        LinkedList<ItemStack> items;
        int selectedSize = BingoObject.getSelectedObjects().size();
        LinkedList<ItemStack> linkedList = items = team == null ? BingoTeam.getDefaultBingoItems(null) : team.getBingoItems();
        if (selectedSize <= 5) {
            return new InventoryBuilder((InventoryHolder)this, InventoryType.HOPPER, "Bingo").addItems(items).normal().build();
        }
        if (selectedSize == 9) {
            return new InventoryBuilder((InventoryHolder)this, InventoryType.DROPPER, "Bingo").addItems(items).normal().build();
        }
        int maxInvSize = 54;
        if (selectedSize < maxInvSize) {
            int invSize = (selectedSize + 8) / 9 * 9;
            return new InventoryBuilder((InventoryHolder)this, invSize, "Bingo").addItems(items).normal().build();
        }
        return new ScrollInventory(this, IChatBaseComponent.b((String)"Bingo"), items, true, new ScrollInventory.Hotbar[0]).setArrowBackEvent("bingo-back", event -> event.getWhoClicked().closeInventory()).start();
    }

    @NotNull
    public Inventory getInventory() {
        return null;
    }
}

