/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.listener.CollectListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;

public class CollectBiomeListener
implements CollectListener<Biome> {
    private static final Map<UUID, Biome> lastPlayerBiome = new HashMap<UUID, Biome>();
    private static final Map<BingoTeam, Set<Biome>> biomesMap = new HashMap<BingoTeam, Set<Biome>>();

    public CollectBiomeListener() {
        CollectListener.CollectScheduler.registerTask(() -> {
            for (Map.Entry<UUID, BingoTeam> entry : CollectListener.CollectScheduler.getPlayerTeamMap().entrySet()) {
                UUID uuid = entry.getKey();
                BingoTeam team = entry.getValue();
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null || !player.isOnline()) continue;
                Biome currentBiome = player.getLocation().getBlock().getBiome();
                Biome lastBiome = lastPlayerBiome.get(uuid);
                if (lastBiome != null && lastBiome == currentBiome) continue;
                lastPlayerBiome.put(uuid, currentBiome);
                biomesMap.putIfAbsent(team, new HashSet());
                Set<Biome> visited = biomesMap.get(team);
                if (!visited.add(currentBiome)) continue;
                this.collect(currentBiome, (OfflinePlayer)player);
            }
        });
    }
}

