/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.ScoreboardManager;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.utils.eisutils.toast.AdvancementFrame;
import de.eisi05.bingo.utils.eisutils.toast.ToastNotification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.scheduler.BukkitRunnable;

public interface CollectListener<T>
extends Listener {
    default public void collect(T object, OfflinePlayer offlinePlayer) {
        if (object == null || GameState.currentGameState != GameState.INGAME) {
            return;
        }
        BingoTeam.getTeam(offlinePlayer.getUniqueId()).ifPresent(team -> {
            Set<BingoObject<?>> missingItems = team.getMissingBingoItems();
            if (missingItems.isEmpty()) {
                return;
            }
            for (BingoObject<?> missingObj : missingItems) {
                BingoObject<?> missing;
                if (!missingObj.getObjectClass().isAssignableFrom(object.getClass()) || !(missing = missingObj).isSimilarObject(object)) continue;
                team.foundBingoItem(missing);
                IChatMutableComponent teamName = team.getName().a(EnumChatFormat.a((char)team.getColor().getChar()));
                IChatMutableComponent foundCount = IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size() - missingItems.size() + 1)).a(style -> style.a(EnumChatFormat.m).a(Boolean.valueOf(true)));
                IChatMutableComponent totalCount = IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size())).a(EnumChatFormat.h);
                IChatMutableComponent message = ((IChatMutableComponent)CraftChatMessage.fromStringOrEmpty((String)Prefix.SERVER)).b((IChatBaseComponent)IChatBaseComponent.b((String)offlinePlayer.getName()).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.h)).b((IChatBaseComponent)teamName).b((IChatBaseComponent)IChatBaseComponent.b((String)") ").a(EnumChatFormat.h)).b((IChatBaseComponent)missing.getFoundVerb().a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)" ")).b((IChatBaseComponent)missing.getName().a(EnumChatFormat.j)).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.i)).b((IChatBaseComponent)foundCount).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(EnumChatFormat.i)).b((IChatBaseComponent)totalCount).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.i));
                ((CraftServer)Bukkit.getServer()).getHandle().broadcastMessage(new IChatBaseComponent[]{message});
                ToastNotification toast = new ToastNotification(missing.asDisplayIcon(), (IChatBaseComponent)missing.getName().a(EnumChatFormat.j).f(" ").b((IChatBaseComponent)missing.getFoundVerb().a(EnumChatFormat.h)), AdvancementFrame.TASK);
                for (UUID playerId : team.getPlayers()) {
                    Player player = Bukkit.getPlayer((UUID)playerId);
                    if (player == null) continue;
                    toast.send(player);
                    player.playSound((Entity)player, Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                    if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof BingoTeam.BingoTeamInventoryHolder)) continue;
                    player.performCommand("bingo");
                }
                Bukkit.getOnlinePlayers().forEach(ScoreboardManager::updateScoreboard);
                if (!team.getMissingBingoItems().isEmpty()) break;
                GameState.setGameState(GameState.FINISH);
                break;
            }
        });
    }

    public static class CollectScheduler {
        private static final List<Runnable> tasks = new ArrayList<Runnable>();
        private static final Map<UUID, BingoTeam> playerTeamMap = new HashMap<UUID, BingoTeam>();
        private static boolean running = false;

        public static void registerTask(Runnable task) {
            tasks.add(task);
            if (!running) {
                for (BingoTeam team : BingoTeam.teams) {
                    for (UUID playerId : team.getPlayers()) {
                        playerTeamMap.put(playerId, team);
                    }
                }
                running = true;
                new BukkitRunnable(){

                    public void run() {
                        for (Runnable r : tasks) {
                            r.run();
                        }
                    }
                }.runTaskTimer(Main.plugin, 0L, 10L);
            }
        }

        public static Map<UUID, BingoTeam> getPlayerTeamMap() {
            return playerTeamMap;
        }
    }
}

