/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.bingo.settings.AmountOfObjectsSetting;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.SettingsManager;
import de.eisi05.bingo.manager.VoteManager;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.lang.Translation;
import java.awt.Color;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatHexColor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.network.PlayerConnection;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;

public final class BingoUtils {
    public static final ChatColor[] teamColors = new ChatColor[]{ChatColor.GREEN, ChatColor.RED, ChatColor.YELLOW, ChatColor.AQUA, ChatColor.LIGHT_PURPLE, ChatColor.GOLD, ChatColor.DARK_GREEN, ChatColor.DARK_AQUA, ChatColor.DARK_PURPLE};
    public static final ItemStack settingItem = new ItemBuilder(Material.NETHER_STAR).setName((IChatBaseComponent)Translation.SETTINGS.f().a(EnumChatFormat.l)).setInteractHandler("settings", event -> SettingsManager.getSettingsInventory().openAsNMS((HumanEntity)event.getPlayer(), new InventoryBuilder.Animation(InventoryBuilder.AnimationType.values()[new Random().nextInt(InventoryBuilder.AnimationType.values().length)], 1, Sound.BLOCK_NOTE_BLOCK_HAT), (IChatBaseComponent)Translation.SETTINGS)).notDroppable().build();
    public static final ItemStack startItem = new ItemBuilder(Material.LIME_DYE).setName((IChatBaseComponent)IChatBaseComponent.b((String)"Start Game").a(EnumChatFormat.k)).setInteractHandler("start-game", event -> {
        if (BingoTeam.teams.stream().allMatch(team -> team.getPlayers().isEmpty())) {
            event.getPlayer().playSound((Entity)event.getPlayer(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
            BingoUtils.sendMessage((HumanEntity)event.getPlayer(), (IChatBaseComponent)IChatBaseComponent.b((String)"Cannot start the game! There are no players on any team!").a(EnumChatFormat.m), true);
            return;
        }
        if (BingoObject.getSelectedObjects() == null || BingoObject.getSelectedObjects().size() != ((Integer)BingoSetting.getSetting(AmountOfObjectsSetting.class).getValue()).intValue()) {
            event.getPlayer().playSound((Entity)event.getPlayer(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
            BingoUtils.sendMessage((HumanEntity)event.getPlayer(), (IChatBaseComponent)IChatBaseComponent.b((String)"Cannot start the game! Bingo objects are still being calculated!").a(EnumChatFormat.m), true);
        }
        GameState.setGameState(GameState.STARTING);
    }).notDroppable().build();
    public static VoteManager<?> voteManager;
    private static final HashMap<Material, Character> materialToCharMap;
    private static final HashMap<EntityType, Character> entityTypeToCharMap;

    public static void load() {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(BingoUtils.class.getClassLoader().getResourceAsStream("CharMapping.yml")));
        for (String key : configuration.getConfigurationSection("materials").getKeys(false)) {
            materialToCharMap.put(Material.valueOf((String)key.toUpperCase()), Character.valueOf((char)Integer.parseInt(configuration.getString("materials." + key).replace("\\u", ""), 16)));
        }
        for (String key : configuration.getConfigurationSection("entity").getKeys(false)) {
            entityTypeToCharMap.put(EntityType.valueOf((String)key.toUpperCase()), Character.valueOf((char)Integer.parseInt(configuration.getString("entity." + key).replace("\\u", ""), 16)));
        }
    }

    public static ItemStack teamSelectItem() {
        return new ItemBuilder(Material.RED_BED).setName((IChatBaseComponent)IChatBaseComponent.b((String)"Select Team").a(EnumChatFormat.m)).setInteractHandler("select-team", event -> {
            BingoTeam.getSelectionInventory(event.getPlayer()).openAsNMS((HumanEntity)event.getPlayer(), (IChatBaseComponent)IChatBaseComponent.b((String)"Team Selection"));
            event.getPlayer().updateInventory();
        }).notDroppable().build();
    }

    public static void sendMessage(HumanEntity player, IChatBaseComponent component, boolean prefix) {
        if (prefix) {
            component = ((IChatMutableComponent)CraftChatMessage.fromStringOrEmpty((String)Prefix.SERVER)).b(component);
        }
        ((CraftPlayer)player).getHandle().a(component);
    }

    public static void sendTitle(HumanEntity player, IChatBaseComponent title, IChatBaseComponent subtitle, int fadeIn, int stay, int fadeOut) {
        PlayerConnection connection = ((CraftPlayer)player).getHandle().g;
        connection.b((Packet)new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut));
        if (title != null) {
            connection.b((Packet)new ClientboundSetTitleTextPacket(title));
        }
        if (subtitle != null) {
            connection.b((Packet)new ClientboundSetSubtitleTextPacket(subtitle));
        }
    }

    public static IChatMutableComponent createComponent(String text) {
        return (IChatMutableComponent)CraftChatMessage.fromStringOrEmpty((String)text);
    }

    public static IChatMutableComponent getItemIcon(Material material, IChatMutableComponent defaultChar) {
        return materialToCharMap.getOrDefault(material, null) == null ? defaultChar : IChatBaseComponent.b((String)String.valueOf(materialToCharMap.get(material))).a(style -> style.b(EnumChatFormat.p.f().intValue()));
    }

    public static IChatMutableComponent getEntityIcon(EntityType type, IChatMutableComponent defaultChar) {
        return entityTypeToCharMap.getOrDefault(type, null) == null ? defaultChar : IChatBaseComponent.b((String)String.valueOf(entityTypeToCharMap.get(type))).a(style -> style.b(EnumChatFormat.p.f().intValue()));
    }

    public static String generateGradientString(String text, String startHex, String endHex) {
        Color startColor = Color.decode(startHex);
        Color endColor = Color.decode(endHex);
        StringBuilder gradientText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            double ratio = (double)i / (double)(text.length() - 1);
            int r = (int)((double)startColor.getRed() * (1.0 - ratio) + (double)endColor.getRed() * ratio);
            int g = (int)((double)startColor.getGreen() * (1.0 - ratio) + (double)endColor.getGreen() * ratio);
            int b = (int)((double)startColor.getBlue() * (1.0 - ratio) + (double)endColor.getBlue() * ratio);
            gradientText.append(net.md_5.bungee.api.ChatColor.of((Color)new Color(r, g, b))).append(text.charAt(i));
        }
        return gradientText.toString();
    }

    public static IChatMutableComponent generateGradientComponent(String text, String startHex, String endHex) {
        Color startColor = Color.decode(startHex);
        Color endColor = Color.decode(endHex);
        IChatMutableComponent components = IChatBaseComponent.i();
        for (int i = 0; i < text.length(); ++i) {
            double ratio = (double)i / (double)(text.length() - 1);
            int r = (int)((double)startColor.getRed() * (1.0 - ratio) + (double)endColor.getRed() * ratio);
            int g = (int)((double)startColor.getGreen() * (1.0 - ratio) + (double)endColor.getGreen() * ratio);
            int b = (int)((double)startColor.getBlue() * (1.0 - ratio) + (double)endColor.getBlue() * ratio);
            components = components.b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(text.charAt(i))).a(style -> style.a(ChatHexColor.a((int)new Color(r, g, b).getRGB()))));
        }
        return components;
    }

    static {
        materialToCharMap = new HashMap();
        entityTypeToCharMap = new HashMap();
    }
}

