/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.settings.AllowEnchantmentsSetting;
import de.eisi05.bingo.bingo.settings.AmountOfObjectsSetting;
import de.eisi05.bingo.bingo.settings.DamageSetting;
import de.eisi05.bingo.bingo.settings.DifficultySetting;
import de.eisi05.bingo.bingo.settings.EndSetting;
import de.eisi05.bingo.bingo.settings.KeepInventorySetting;
import de.eisi05.bingo.bingo.settings.ManageObjectsSetting;
import de.eisi05.bingo.bingo.settings.NetherSetting;
import de.eisi05.bingo.bingo.settings.ObjectTypesSetting;
import de.eisi05.bingo.bingo.settings.PVPSetting;
import de.eisi05.bingo.bingo.settings.PlayerPerTeamSetting;
import de.eisi05.bingo.bingo.settings.RandomizerSetting;
import de.eisi05.bingo.bingo.settings.SaturationSetting;
import de.eisi05.bingo.bingo.settings.ServerRestartSetting;
import de.eisi05.bingo.bingo.settings.TimeSetting;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.config.Configuration;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.item.component.ItemLore;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract sealed class BingoSetting<T>
permits AllowEnchantmentsSetting, AmountOfObjectsSetting, DamageSetting, DifficultySetting, EndSetting, KeepInventorySetting, ManageObjectsSetting, NetherSetting, ObjectTypesSetting, PVPSetting, PlayerPerTeamSetting, RandomizerSetting, SaturationSetting, ServerRestartSetting, TimeSetting {
    protected static final String filePath = "BingoSettings.yml";
    protected static final HashMap<BingoSetting<?>, Object> map = new HashMap();
    private static final HashMap<Class<? extends BingoSetting<?>>, BingoSetting<?>> settings = new HashMap();

    public static <T extends BingoSetting<?>> T getSetting(Class<T> clazz) {
        return (T)settings.get(clazz);
    }

    public static BingoSetting<?>[] values() {
        return settings.values().toArray(new BingoSetting[0]);
    }

    protected void handleBooleanSetting(BingoSetting<Boolean> setting, ItemStack item) {
        setting.setValue(setting.getValue() == false);
        ItemMeta meta = item.getItemMeta();
        meta.setEnchantmentGlintOverride(setting.getValue());
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        List lore = ((ItemLore)nmsItemStack.a(DataComponents.j)).a();
        lore.set(0, setting.getValue() != false ? IChatBaseComponent.b((String)"Enabled").a(style -> style.a(EnumChatFormat.k).b(Boolean.valueOf(false))) : IChatBaseComponent.b((String)"Disabled").a(style -> style.a(EnumChatFormat.m).b(Boolean.valueOf(false))));
        nmsItemStack.b(DataComponentMap.a().a(DataComponents.j, (Object)lore.stream().reduce(ItemLore.a, ItemLore::a, (lore1, lore2) -> lore1)).a(DataComponents.t, (Object)setting.getValue()).a());
        item.setItemMeta(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack).getItemMeta());
    }

    public abstract T getDefaultValue();

    public abstract ItemBuilder getIcon();

    public abstract IChatBaseComponent getSettingsText();

    public abstract int getSlot();

    public abstract List<Triple<String, String, Boolean>> getDescriptionKeys();

    protected IChatBaseComponent[] getDescription(boolean withNewLine) {
        Stream<IChatBaseComponent> componentStream = this.getDescriptionKeys().stream().map(entry -> IChatBaseComponent.a((String)((String)entry.getLeft()), (String)((String)entry.getMiddle())).a(style -> style.a(EnumChatFormat.h).b((Boolean)entry.getRight())));
        if (withNewLine) {
            componentStream = Stream.concat(Stream.of(IChatBaseComponent.i()), componentStream);
        }
        return componentStream.toList().toArray(new IChatBaseComponent[0]);
    }

    public T getValue() {
        if (!map.containsKey(this)) {
            return this.getDefaultValue();
        }
        return (T)map.get(this);
    }

    public void setValue(T t) {
        map.put(this, t);
        Configuration.MyConfig config = new Configuration(Main.plugin.getDataFolder(), filePath).getConfig();
        config.set(this.getClass().getSimpleName(), this.serialize(t));
    }

    public Object serialize(T t) {
        return t;
    }

    public T deserialize(Object o) {
        return (T)o;
    }

    static {
        for (Class<?> setting : BingoSetting.class.getPermittedSubclasses()) {
            try {
                Object deserialized;
                Object object;
                BingoSetting bingoSetting = (BingoSetting)setting.getDeclaredConstructors()[0].newInstance(new Object[0]);
                settings.put(setting, bingoSetting);
                Configuration.MyConfig config = new Configuration(Main.plugin.getDataFolder(), filePath).getConfig();
                if (bingoSetting.getDefaultValue() == null || !config.contains(bingoSetting.getClass().getSimpleName()) || (object = config.get(bingoSetting.getClass().getSimpleName())) == null || (deserialized = bingoSetting.deserialize(object)) == null) continue;
                map.put(bingoSetting, deserialized);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

