/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import de.eisi05.bingo.listener.CollectListener;
import java.util.Collection;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructurePiece;
import org.bukkit.util.BoundingBox;

public class CollectStructureListener
implements CollectListener<Structure> {
    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        Collection structures = event.getTo().getWorld().getStructures(event.getTo().getChunk().getX(), event.getTo().getChunk().getZ());
        if (structures.isEmpty()) {
            return;
        }
        block0: for (GeneratedStructure generatedStructure : structures) {
            for (StructurePiece piece : generatedStructure.getPieces()) {
                BoundingBox box = this.ensureMinSize(piece.getBoundingBox(), 3.0);
                if (!box.overlaps(event.getPlayer().getBoundingBox()) && !box.contains(event.getPlayer().getBoundingBox())) continue;
                this.collect(generatedStructure.getStructure(), (OfflinePlayer)event.getPlayer());
                continue block0;
            }
        }
    }

    private BoundingBox ensureMinSize(BoundingBox box, double minSize) {
        double expandX = box.getWidthX() < minSize ? minSize - box.getWidthX() : 0.0;
        double expandY = box.getHeight() < minSize ? minSize - box.getHeight() : 0.0;
        double expandZ = box.getWidthZ() < minSize ? minSize - box.getWidthZ() : 0.0;
        return box.clone().expand(expandX, expandY, expandZ);
    }
}

