/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandRegistrationStrategy;
import dev.jorel.commandapi.RegisteredCommand;
import dev.jorel.commandapi.SafeVarHandle;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.bukkit.help.HelpTopic;

public class PaperCommandRegistration<Source>
extends CommandRegistrationStrategy<Source> {
    private final Supplier<CommandDispatcher<Source>> getBrigadierDispatcher;
    private final Runnable reloadHelpTopics;
    private final Predicate<CommandNode<Source>> isBukkitCommand;
    private final RootCommandNode<Source> registeredNodes = new RootCommandNode();
    private static final Object paperCommandsInstance;
    private static final Field dispatcherField;
    private static final Constructor<?> pluginCommandNodeConstructor;
    private static final SafeVarHandle<CommandNode<?>, Object> metaField;

    public PaperCommandRegistration(Supplier<CommandDispatcher<Source>> getBrigadierDispatcher, Runnable reloadHelpTopics, Predicate<CommandNode<Source>> isBukkitCommand) {
        this.getBrigadierDispatcher = getBrigadierDispatcher;
        this.reloadHelpTopics = reloadHelpTopics;
        this.isBukkitCommand = isBukkitCommand;
    }

    public boolean isBukkitCommand(CommandNode<Source> node) {
        return this.isBukkitCommand.test(node);
    }

    public CommandDispatcher<Source> getPaperDispatcher() {
        try {
            return (CommandDispatcher)dispatcherField.get(paperCommandsInstance);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public CommandDispatcher<Source> getBrigadierDispatcher() {
        return this.getBrigadierDispatcher.get();
    }

    @Override
    public void runTasksAfterServerStart() {
    }

    @Override
    public void postCommandRegistration(RegisteredCommand registeredCommand, LiteralCommandNode<Source> resultantNode, List<LiteralCommandNode<Source>> aliasNodes) {
    }

    @Override
    public LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> node, String namespace) {
        LiteralCommandNode<Source> commandNode = this.asPluginCommand(node.build());
        LiteralCommandNode<Source> namespacedCommandNode = this.asPluginCommand(CommandAPIHandler.getInstance().namespaceNode(commandNode, namespace));
        this.registeredNodes.addChild(commandNode);
        this.registeredNodes.addChild(namespacedCommandNode);
        RootCommandNode root = this.getPaperDispatcher().getRoot();
        root.addChild(commandNode);
        root.addChild(namespacedCommandNode);
        return commandNode;
    }

    @Override
    public void unregister(String commandName, boolean unregisterNamespaces, boolean unregisterBukkit) {
        this.removeBrigadierCommands(this.getBrigadierDispatcher().getRoot(), commandName, unregisterNamespaces, c -> !unregisterBukkit ^ this.isBukkitCommand.test((CommandNode<Source>)c));
        if (!unregisterBukkit) {
            this.removeBrigadierCommands(this.registeredNodes, commandName, unregisterNamespaces, c -> true);
        }
        CommandAPIHandler.getInstance().writeDispatcherToFile();
    }

    @Override
    public void preReloadDataPacks() {
        RootCommandNode root = this.getPaperDispatcher().getRoot();
        for (CommandNode commandNode : this.registeredNodes.getChildren()) {
            root.addChild(commandNode);
        }
        this.reloadHelpTopics.run();
        CommandAPIBukkit.get().updateHelpForCommands(CommandAPI.getRegisteredCommands());
    }

    private LiteralCommandNode<Source> asPluginCommand(LiteralCommandNode<Source> commandNode) {
        try {
            if (metaField == null) {
                return (LiteralCommandNode)pluginCommandNodeConstructor.newInstance(commandNode.getLiteral(), CommandAPIBukkit.getConfiguration().getPlugin().getPluginMeta(), commandNode, this.getDescription(commandNode.getLiteral()));
            }
            this.setPluginCommandMeta(commandNode);
            return commandNode;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void setPluginCommandMeta(LiteralCommandNode<Source> node) {
        try {
            metaField.set((CommandNode<?>)node, pluginCommandNodeConstructor.newInstance(CommandAPIBukkit.getConfiguration().getPlugin().getPluginMeta(), this.getDescription(node.getLiteral()), this.getAliasesForCommand(node.getLiteral())));
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            try {
                metaField.set((CommandNode<?>)node, pluginCommandNodeConstructor.newInstance(CommandAPIBukkit.getConfiguration().getPlugin().getPluginMeta(), this.getDescription(node.getLiteral()), this.getAliasesForCommand(node.getLiteral()), CommandAPIBukkit.getConfiguration().getNamespace(), false));
            }
            catch (IllegalArgumentException | ReflectiveOperationException e1) {
                try {
                    metaField.set((CommandNode<?>)node, pluginCommandNodeConstructor.newInstance(CommandAPIBukkit.getConfiguration().getPlugin().getPluginMeta(), this.getDescription(node.getLiteral()), this.getAliasesForCommand(node.getLiteral()), CommandAPIBukkit.getConfiguration().getNamespace()));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
    }

    private String getDescription(String commandName) {
        String namespaceStripped = commandName.contains(":") ? commandName.split(":")[1] : commandName;
        for (RegisteredCommand command : CommandAPI.getRegisteredCommands()) {
            if (!command.commandName().equals(namespaceStripped) && !Arrays.asList(command.aliases()).contains(namespaceStripped)) continue;
            Object helpTopic = command.helpTopic().orElse(null);
            if (helpTopic != null) {
                return ((HelpTopic)helpTopic).getShortText();
            }
            return command.shortDescription().orElse("A command by the " + CommandAPIBukkit.getConfiguration().getPlugin().getName() + " plugin.");
        }
        return "";
    }

    private List<String> getAliasesForCommand(String commandName) {
        HashSet<String> aliases = new HashSet<String>();
        String namespaceStripped = commandName.contains(":") ? commandName.split(":")[1] : commandName;
        for (RegisteredCommand command : CommandAPI.getRegisteredCommands()) {
            if (!command.commandName().equals(namespaceStripped)) continue;
            aliases.addAll(Arrays.asList(command.aliases()));
        }
        return new ArrayList<String>(aliases);
    }

    static {
        Constructor<?> commandNode;
        Object paperCommandsInstanceObject = null;
        Field dispatcherFieldObject = null;
        try {
            Class<?> paperCommands = Class.forName("io.papermc.paper.command.brigadier.PaperCommands");
            paperCommandsInstanceObject = paperCommands.getField("INSTANCE").get(null);
            dispatcherFieldObject = paperCommands.getDeclaredField("dispatcher");
        }
        catch (ReflectiveOperationException paperCommands) {
            // empty catch block
        }
        paperCommandsInstance = paperCommandsInstanceObject;
        dispatcherField = dispatcherFieldObject;
        dispatcherField.setAccessible(true);
        SafeVarHandle<CommandNode, ?> metaFieldHandle = null;
        try {
            commandNode = Class.forName("io.papermc.paper.command.brigadier.PluginCommandNode").getDeclaredConstructor(String.class, PluginMeta.class, LiteralCommandNode.class, String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            try {
                Class<?> pluginCommandMeta = Class.forName("io.papermc.paper.command.brigadier.PluginCommandMeta");
                commandNode = pluginCommandMeta.getDeclaredConstructor(PluginMeta.class, String.class, List.class);
                metaFieldHandle = SafeVarHandle.ofOrNull(CommandNode.class, "pluginCommandMeta", "pluginCommandMeta", pluginCommandMeta);
            }
            catch (ClassNotFoundException | NoSuchMethodException e1) {
                try {
                    Class<?> apiCommandMeta = Class.forName("io.papermc.paper.command.brigadier.APICommandMeta");
                    commandNode = apiCommandMeta.getDeclaredConstructor(PluginMeta.class, String.class, List.class, String.class, Boolean.TYPE);
                    metaFieldHandle = SafeVarHandle.ofOrNull(CommandNode.class, "apiCommandMeta", "apiCommandMeta", apiCommandMeta);
                }
                catch (ClassNotFoundException | NoSuchMethodException e2) {
                    try {
                        Class<?> apiCommandMeta = Class.forName("io.papermc.paper.command.brigadier.APICommandMeta");
                        commandNode = apiCommandMeta.getDeclaredConstructor(PluginMeta.class, String.class, List.class, String.class);
                        metaFieldHandle = SafeVarHandle.ofOrNull(CommandNode.class, "apiCommandMeta", "apiCommandMeta", apiCommandMeta);
                    }
                    catch (ClassNotFoundException | NoSuchMethodException e3) {
                        commandNode = null;
                    }
                }
            }
        }
        pluginCommandNodeConstructor = commandNode;
        metaField = metaFieldHandle;
    }
}

