/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.utils.eisutils.ObjectSaver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;

public final class BingoObjectsHandler {
    private static final File FILE = new File(Main.plugin.getDataFolder(), "Objects.bingo");
    private static boolean corrupted = true;

    private BingoObjectsHandler() {
    }

    public static void loadObjects() {
        BingoObject.bingoObjects.clear();
        if (!FILE.exists()) {
            Main.plugin.saveResource("Objects.bingo", false);
        }
        List objects = new ObjectSaver(FILE).readList();
        corrupted = !corrupted;
        for (BingoObject.SerializedBingoObject sbo : objects) {
            try {
                sbo.toBingoObject();
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("Failed to load BingoObject: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (BingoObject.bingoObjects.isEmpty() && !corrupted) {
            Main.plugin.saveResource("Objects.bingo", true);
            BingoObjectsHandler.loadObjects();
            return;
        }
        BingoObject.loadBingoObjects();
        Bukkit.getLogger().info("Loaded " + BingoObject.bingoObjects.size() + " Bingo Objects");
    }

    public static void saveObjects() {
        File parent = FILE.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            Bukkit.getLogger().severe("Failed to create directory for saving Bingo objects!");
            return;
        }
        new ObjectSaver(FILE).writeList(BingoObject.bingoObjects.stream().map(BingoObject::toSerializedBingoObject).collect(Collectors.toCollection(ArrayList::new)), false);
    }
}

