/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.PlayerPerTeamSetting;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.Var;
import de.eisi05.bingo.utils.eisutils.ColorConverter;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.builder.NMSScoreboardBuilder;
import de.eisi05.bingo.utils.eisutils.builder.RecipeInventory;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoTeam {
    public static final List<BingoTeam> teams = new ArrayList<BingoTeam>();
    private final int id;
    private final ChatColor color;
    private final Set<UUID> players = new HashSet<UUID>();
    private final List<BingoObject<?>> collectedObjects = new ArrayList();
    private final Map<Advancement, AdvancementProgress> advancementProgresses = new HashMap<Advancement, AdvancementProgress>();
    private final Inventory backpack;
    private LinkedList<ItemStack> bingoItemsCache = null;
    private int bingoItemsCacheHash = -1;

    private BingoTeam(int id, ChatColor color) {
        this.id = id;
        this.color = color;
        this.backpack = Bukkit.createInventory(null, (int)27, (String)("Backpack >> " + String.valueOf(this.getName())));
        teams.add(this);
    }

    public static Optional<BingoTeam> getTeam(UUID player) {
        for (BingoTeam team : teams) {
            if (!team.getPlayers().contains(player)) continue;
            return Optional.of(team);
        }
        return Optional.empty();
    }

    public static void createBingoTeams() {
        ArrayList<ChatColor> colors = new ArrayList<ChatColor>(List.of(BingoUtils.teamColors));
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 9; ++i) {
            new BingoTeam(i + 1, (ChatColor)colors.remove(random.nextInt(colors.size())));
        }
    }

    public static InventoryBuilder getSelectionInventory(Player player) {
        LinkedList<BingoTeam> sorted = BingoTeam.getSortedTeams();
        int invSize = (sorted.size() + 8) / 9 * 9;
        InventoryBuilder inventoryBuilder = new InventoryBuilder((InventoryHolder)new BingoTeamInventoryHolder(), invSize, "Team Selection");
        for (int i = 0; i < sorted.size(); ++i) {
            BingoTeam current = (BingoTeam)sorted.get(i);
            inventoryBuilder.setItem(i, current.getIcon().setEnchantmentGlint(current.players.contains(player.getUniqueId())).setClickHandler("team-join-" + current.id, event -> {
                if (current.isFull()) {
                    BingoUtils.sendMessage(event.getWhoClicked(), (IChatBaseComponent)IChatBaseComponent.b((String)"This team is full!").a(EnumChatFormat.m), true);
                    ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
                    return;
                }
                BingoTeam.getTeam(event.getWhoClicked().getUniqueId()).ifPresent(team -> team.removePlayer(event.getWhoClicked()));
                current.addPlayer(event.getWhoClicked());
                event.getWhoClicked().closeInventory();
                BingoTeam.updateInventory();
                BingoUtils.sendMessage(event.getWhoClicked(), (IChatBaseComponent)IChatBaseComponent.b((String)("You joined team " + CraftChatMessage.fromComponent((IChatBaseComponent)current.getName()))).a(EnumChatFormat.h), true);
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            }).build());
        }
        return inventoryBuilder.normal();
    }

    private static void updateInventory() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Inventory top = player.getOpenInventory().getTopInventory();
            if (top == null || !(top.getHolder() instanceof BingoTeamInventoryHolder)) continue;
            BingoTeam.getSelectionInventory(player).openAsNMS((HumanEntity)player, (IChatBaseComponent)IChatBaseComponent.b((String)"Team Selection"));
        }
    }

    public static LinkedList<BingoTeam> getSortedTeams() {
        return teams.stream().sorted(Comparator.comparingInt(t -> t.id)).collect(Collectors.toCollection(LinkedList::new));
    }

    public static void addPlayerToSpectator(HumanEntity player) {
        Bukkit.getOnlinePlayers().forEach(online -> new NMSScoreboardBuilder((Player)online).addPlayerToTeamByEntry((OfflinePlayer)((Player)player), "team0"));
    }

    public int getId() {
        return this.id;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public IChatMutableComponent getName() {
        return BingoUtils.createComponent(this.getNameAsString());
    }

    public String getNameAsString() {
        return String.valueOf(this.color) + "#" + this.id;
    }

    public Inventory getBackpack() {
        return this.backpack;
    }

    public ItemBuilder getIcon() {
        ItemBuilder itemBuilder = new ItemBuilder(Material.valueOf((String)(ColorConverter.getColor(this.color).name() + "_BED"))).setName((IChatBaseComponent)this.getName());
        ArrayList<IChatMutableComponent> lore = new ArrayList<IChatMutableComponent>();
        for (UUID uuid : this.players) {
            lore.add(IChatBaseComponent.b((String)Bukkit.getOfflinePlayer((UUID)uuid).getName()).a(style -> style.a(EnumChatFormat.h).b(Boolean.valueOf(false))));
        }
        for (int i = lore.size(); i < (Integer)BingoSetting.getSetting(PlayerPerTeamSetting.class).getValue(); ++i) {
            lore.add(IChatBaseComponent.b((String)" --- ").a(style -> style.a(EnumChatFormat.h).b(Boolean.valueOf(false))));
        }
        return itemBuilder.setLore(lore.toArray(new IChatBaseComponent[0]));
    }

    public static LinkedList<ItemStack> getDefaultBingoItems(@Nullable BingoTeam team) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (BingoObject<?> bingoObject : BingoObject.getSelectedObjects()) {
            IChatBaseComponent[] iChatBaseComponentArray;
            if (team != null && bingoObject.hasFound(team)) {
                list.add(new ItemBuilder(Material.LIME_STAINED_GLASS_PANE).setEnchantmentGlint(true).setName(bingoObject.asDisplayIcon().getItemMeta().getDisplayName()).clearAttributes().hideToolTip().build());
                continue;
            }
            IChatMutableComponent preLore = null;
            if (bingoObject instanceof BingoObject.BingoAdvancement) {
                BingoObject.BingoAdvancement bingoAdvancement = (BingoObject.BingoAdvancement)bingoObject;
                preLore = IChatBaseComponent.a((String)("advancements." + ((Advancement)bingoAdvancement.object).getKey().getKey().replace("/", ".") + ".description"), (String)((Advancement)bingoAdvancement.object).getDisplay().getDescription());
            }
            IChatMutableComponent lore = IChatBaseComponent.b((String)"> ").b((IChatBaseComponent)BingoObject.getName(bingoObject.getClass())).a(EnumChatFormat.h);
            ItemBuilder itemBuilder = new ItemBuilder(bingoObject.asDisplayIcon());
            if (preLore == null) {
                IChatBaseComponent[] iChatBaseComponentArray2 = new IChatBaseComponent[1];
                iChatBaseComponentArray = iChatBaseComponentArray2;
                iChatBaseComponentArray2[0] = lore;
            } else {
                IChatBaseComponent[] iChatBaseComponentArray3 = new IChatBaseComponent[3];
                iChatBaseComponentArray3[0] = preLore;
                iChatBaseComponentArray3[1] = IChatBaseComponent.i();
                iChatBaseComponentArray = iChatBaseComponentArray3;
                iChatBaseComponentArray3[2] = lore;
            }
            list.add(itemBuilder.setLore(iChatBaseComponentArray).setClickHandler("cancel", event -> event.setCancelled(true)).build());
        }
        return list;
    }

    public boolean isFull() {
        return this.players.size() >= (Integer)BingoSetting.getSetting(PlayerPerTeamSetting.class).getValue();
    }

    public void addPlayer(HumanEntity player) {
        this.players.add(player.getUniqueId());
        for (Player online : Bukkit.getOnlinePlayers()) {
            new NMSScoreboardBuilder(online).addPlayerToTeam((OfflinePlayer)((Player)player), this.getNameAsString());
        }
    }

    public void foundBingoItem(BingoObject<?> bingoObject) {
        this.collectedObjects.add(bingoObject);
    }

    public boolean hasFoundBingoItem(BingoObject<?> bingoObject) {
        return this.collectedObjects.contains(bingoObject);
    }

    public Set<BingoObject<?>> getMissingBingoItems() {
        return BingoObject.getSelectedObjects().stream().filter(bingoObject -> !this.collectedObjects.contains(bingoObject)).collect(Collectors.toSet());
    }

    public void updateAdvancementProgresses() {
        List bingoAdvancements = BingoObject.getBingoObjects(BingoObject.BingoAdvancement.class);
        HashSet<UUID> activePlayers = new HashSet<UUID>(this.getPlayers());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!activePlayers.contains(player.getUniqueId())) continue;
            for (BingoObject bingoAdv : bingoAdvancements) {
                AdvancementProgress progress = player.getAdvancementProgress((Advancement)bingoAdv.getObject());
                Advancement advancement = progress.getAdvancement();
                this.advancementProgresses.compute(advancement, (adv, storedProgress) -> {
                    if (storedProgress == null) {
                        return progress;
                    }
                    Collection storedCriteria = storedProgress.getAwardedCriteria();
                    Collection currentCriteria = progress.getAwardedCriteria();
                    if (storedCriteria.size() > currentCriteria.size()) {
                        storedCriteria.forEach(arg_0 -> ((AdvancementProgress)progress).awardCriteria(arg_0));
                    } else if (storedCriteria.size() < currentCriteria.size()) {
                        currentCriteria.forEach(arg_0 -> ((AdvancementProgress)storedProgress).awardCriteria(arg_0));
                    }
                    return storedProgress;
                });
            }
        }
    }

    public void removePlayer(HumanEntity player) {
        this.players.remove(player.getUniqueId());
        for (Player online : Bukkit.getOnlinePlayers()) {
            new NMSScoreboardBuilder(online).removePlayerFromTeam((OfflinePlayer)((Player)player), this.getNameAsString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public LinkedList<ItemStack> getBingoItems() {
        currentHash = this.computeBingoHash();
        if (this.bingoItemsCacheHash == currentHash && this.bingoItemsCache != null) {
            return this.bingoItemsCache;
        }
        list = new LinkedList<ItemStack>();
        for (BingoObject<?> bingoObject : BingoObject.getSelectedObjects()) {
            if (bingoObject.hasFound(this)) {
                list.add(new ItemBuilder(Material.LIME_STAINED_GLASS_PANE).setEnchantmentGlint(true).setName(bingoObject.asDisplayIcon().getItemMeta().getDisplayName()).clearAttributes().hideToolTip().build());
                continue;
            }
            preLore = null;
            if (bingoObject instanceof BingoObject.BingoAdvancement) {
                bingoAdvancement = (BingoObject.BingoAdvancement)bingoObject;
                preLore = IChatBaseComponent.a((String)("advancements." + ((Advancement)bingoAdvancement.object).getKey().getKey().replace("/", ".") + ".description"), (String)((Advancement)bingoAdvancement.object).getDisplay().getDescription());
            }
            v0 = IChatBaseComponent.b((String)"> ").b((IChatBaseComponent)BingoObject.getName(bingoObject.getClass())).a(EnumChatFormat.h);
            if (!(bingoObject instanceof BingoObject.BingoAdvancement)) ** GOTO lbl-1000
            bingoAdvancement = (BingoObject.BingoAdvancement)bingoObject;
            if (((Advancement)bingoAdvancement.object).getRequirements().getRequirements().size() > 1) {
                v1 = " (" + String.valueOf(this.advancementProgresses.entrySet().stream().filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBingoItems$9(de.eisi05.bingo.bingo.BingoObject$BingoAdvancement java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)((BingoObject.BingoAdvancement)bingoAdvancement)).map((Function<Map.Entry, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBingoItems$10(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/Integer;)()).findFirst().orElse(0)) + "/" + ((Advancement)bingoAdvancement.object).getRequirements().getRequirements().size() + ")";
            } else lbl-1000:
            // 2 sources

            {
                v1 = "";
            }
            v2 = IChatBaseComponent.b((String)v1);
            if (bingoObject instanceof BingoObject.BingoItem) {
                bingoItem = (BingoObject.BingoItem)bingoObject;
                v3 = new RecipeInventory(((ItemStack)bingoItem.object).getType()).isCraftable() ? IChatBaseComponent.b((String)" (").a((UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBingoItems$11(net.minecraft.network.chat.ChatModifier ), (Lnet/minecraft/network/chat/ChatModifier;)Lnet/minecraft/network/chat/ChatModifier;)()).b((IChatBaseComponent)IChatBaseComponent.b((String)"Click to view Recipe")).b((IChatBaseComponent)IChatBaseComponent.b((String)")")) : IChatBaseComponent.i();
            } else {
                v3 = IChatBaseComponent.i();
            }
            lore = v0.b((IChatBaseComponent)v2.b((IChatBaseComponent)v3));
            skipItemLore = IChatBaseComponent.b((String)"Shift + Right-Click to vote skip").a((UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBingoItems$12(net.minecraft.network.chat.ChatModifier ), (Lnet/minecraft/network/chat/ChatModifier;)Lnet/minecraft/network/chat/ChatModifier;)());
            v4 = new ItemBuilder(bingoObject.asDisplayIcon());
            if (preLore == null) {
                v5 = new IChatBaseComponent[2];
                v5[0] = lore;
                v6 = v5;
                v5[1] = skipItemLore;
            } else {
                v7 = new IChatBaseComponent[4];
                v7[0] = preLore;
                v7[1] = IChatBaseComponent.i();
                v7[2] = lore;
                v6 = v7;
                v7[3] = skipItemLore;
            }
            list.add(v4.setLore(v6).setClickHandler("bingo-item-" + bingoObject.hashCode(), (Consumer<InventoryClickEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getBingoItems$28(de.eisi05.bingo.bingo.BingoObject org.bukkit.event.inventory.InventoryClickEvent ), (Lorg/bukkit/event/inventory/InventoryClickEvent;)V)(bingoObject)).build());
        }
        this.bingoItemsCache = list;
        this.bingoItemsCacheHash = currentHash;
        return list;
    }

    private int computeBingoHash() {
        int hash = 0;
        for (BingoObject<?> bingoObject : BingoObject.getSelectedObjects()) {
            hash += bingoObject.hashCode();
            if (bingoObject instanceof BingoObject.BingoAdvancement) {
                BingoObject.BingoAdvancement bingoAdvancement = (BingoObject.BingoAdvancement)bingoObject;
                AdvancementProgress progress = this.advancementProgresses.get(bingoAdvancement.object);
                if (progress != null) {
                    hash += progress.getAwardedCriteria().stream().mapToInt(String::hashCode).sum();
                }
            }
            if (!this.hasFoundBingoItem(bingoObject)) continue;
            hash += 1000000;
        }
        return hash;
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    private static /* synthetic */ void lambda$getBingoItems$28(BingoObject bingoObject, InventoryClickEvent event) {
        event.setCancelled(true);
        if (event.getClick().isShiftClick() && event.getClick().isRightClick()) {
            Optional<BingoTeam> team = BingoTeam.getTeam(event.getWhoClicked().getUniqueId());
            if (team.isEmpty()) {
                return;
            }
            if (teams.stream().filter(team1 -> !team1.getPlayers().isEmpty()).anyMatch(team1 -> team1.hasFoundBingoItem(bingoObject))) {
                BingoUtils.sendMessage(event.getWhoClicked(), (IChatBaseComponent)IChatBaseComponent.b((String)"This object cannot be skipped because a team has already found it!").a(style -> style.a(EnumChatFormat.m)), true);
                return;
            }
            if (BingoUtils.voteManager.hasVoted(team.get(), bingoObject)) {
                BingoUtils.sendMessage(event.getWhoClicked(), (IChatBaseComponent)IChatBaseComponent.b((String)"Your team has already voted to skip this object!").a(style -> style.a(EnumChatFormat.m)), true);
                return;
            }
            BingoUtils.sendMessage(event.getWhoClicked(), (IChatBaseComponent)IChatBaseComponent.b((String)"Your team has voted to skip ").a(style -> style.a(EnumChatFormat.h)).b((IChatBaseComponent)bingoObject.getName().a(style -> style.a(EnumChatFormat.j))), true);
            IChatMutableComponent message = IChatBaseComponent.b((String)"[").a(style -> style.a(EnumChatFormat.i)).b((IChatBaseComponent)team.get().getName().b((IChatBaseComponent)IChatBaseComponent.b((String)"]").a(style -> style.a(EnumChatFormat.i)).b((IChatBaseComponent)IChatBaseComponent.b((String)" has voted to skip ").a(style -> style.a(EnumChatFormat.h)).b((IChatBaseComponent)bingoObject.getName().a(style -> style.a(EnumChatFormat.j)).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(style -> style.a(EnumChatFormat.i)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoUtils.voteManager.getVoteCount(bingoObject) + 1)).a(style -> style.a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(style -> style.a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoUtils.voteManager.neededVotes())).a(style -> style.a(EnumChatFormat.m)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(style -> style.a(EnumChatFormat.i)))))))))));
            IChatMutableComponent prefix = IChatBaseComponent.b((String)"[").a(EnumChatFormat.i).b((IChatBaseComponent)Main.bingoPrefixComponent.f().b((IChatBaseComponent)IChatBaseComponent.b((String)"] ").a(EnumChatFormat.i)));
            ((CraftServer)Bukkit.getServer()).getHandle().broadcastMessage(new IChatBaseComponent[]{prefix.b((IChatBaseComponent)message)});
            BingoUtils.voteManager.addVote(team.get(), (BingoObject)Var.unsafeCast(bingoObject));
            event.getWhoClicked().setItemOnCursor(null);
            event.getWhoClicked().closeInventory();
            ((Player)event.getWhoClicked()).updateInventory();
            return;
        }
        IChatMutableComponent message = IChatBaseComponent.b((String)"Item cannot be crafted!").a(EnumChatFormat.m);
        if (!new RecipeInventory(event.getCurrentItem().getType()).setNotFoundMessage((IChatBaseComponent)message).open((Player)event.getWhoClicked())) {
            BingoUtils.sendMessage(event.getWhoClicked(), (IChatBaseComponent)message, true);
        }
    }

    private static /* synthetic */ ChatModifier lambda$getBingoItems$12(ChatModifier style) {
        return style.a(EnumChatFormat.h).b(Boolean.valueOf(true));
    }

    private static /* synthetic */ ChatModifier lambda$getBingoItems$11(ChatModifier style) {
        return style.a(EnumChatFormat.h).b(Boolean.valueOf(true));
    }

    private static /* synthetic */ Integer lambda$getBingoItems$10(Map.Entry advancementProgress) {
        return ((AdvancementProgress)advancementProgress.getValue()).getAwardedCriteria().size();
    }

    private static /* synthetic */ boolean lambda$getBingoItems$9(BingoObject.BingoAdvancement bingoAdvancement, Map.Entry advancementProgress) {
        return ((Advancement)advancementProgress.getKey()).equals(bingoAdvancement.object);
    }

    public static class BingoTeamInventoryHolder
    implements InventoryHolder {
        @NotNull
        public Inventory getInventory() {
            return null;
        }
    }
}

