/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.manager;

import de.eisi05.bingo.utils.eisutils.lists.ItemList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;

public class RandomizeManager {
    private static final Map<Material, List<Material>> map = new HashMap<Material, List<Material>>();

    public static void createMapping() {
        List blocks = Arrays.stream(Material.values()).filter(material -> material.isBlock() && material.getHardness() != -1.0f && !ItemList.notObtainableInSurvival.contains(material)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        List items = ItemList.materials.stream().filter(material -> !ItemList.notObtainableInSurvival.contains(material)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Collections.shuffle(blocks);
        Collections.shuffle(items);
        int blockCount = blocks.size();
        int index = 0;
        while (!items.isEmpty()) {
            Material block = (Material)blocks.get(index++ % blockCount);
            Material item = (Material)items.remove(ThreadLocalRandom.current().nextInt(items.size()));
            map.computeIfAbsent(block, k -> new ArrayList()).add(item);
        }
    }

    public static List<Material> getItems(Material block) {
        return map.getOrDefault(block, Collections.emptyList());
    }
}

