/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.eisutils.builder;

import com.mojang.datafixers.util.Pair;
import de.eisi05.bingo.Main;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.inventory.InventorySaver;
import de.eisi05.bingo.utils.eisutils.inventory.ScrollInventoryHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ScrollInventory
implements Listener {
    private InventoryHolder inventoryHolder;
    private int page;
    private IChatMutableComponent title;
    private List<ItemStack> items;
    private boolean showPage;
    private Hotbar[] hotbars;
    private Pair<String, Consumer<InventoryClickEvent>> arrowBackEvent;
    private final IChatMutableComponent nextText = IChatBaseComponent.b((String)"Next Page").a(EnumChatFormat.o);
    private final IChatMutableComponent backText = IChatBaseComponent.b((String)"Previous Page").a(EnumChatFormat.o);

    public ScrollInventory(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    public ScrollInventory(InventoryHolder inventoryHolder, IChatMutableComponent name, List<ItemStack> items, boolean showPage, Hotbar ... hotbars) {
        this.inventoryHolder = inventoryHolder == null ? new ScrollInventoryHolder<Object>(null, this) : new ScrollInventoryHolder<InventoryHolder>(inventoryHolder, this);
        this.title = name;
        this.items = new ArrayList<ItemStack>(items);
        this.showPage = showPage;
        this.hotbars = hotbars;
        Bukkit.getPluginManager().registerEvents((Listener)this, Main.plugin);
    }

    public ScrollInventory setArrowBackEvent(String typeName, Consumer<InventoryClickEvent> event) {
        this.arrowBackEvent = new Pair((Object)typeName, event);
        return this;
    }

    public void replaceHotbar(int slot, Hotbar hotbar) {
        for (int i = 0; i < this.hotbars.length; ++i) {
            if (this.hotbars[i].slot != slot) continue;
            this.hotbars[i] = hotbar;
            break;
        }
    }

    public InventoryBuilder getInventory(int page) {
        this.page = page--;
        if (this.isEmpty()) {
            return this.getInventory(page);
        }
        InventoryBuilder builder = this.showPage ? new InventoryBuilder(this.inventoryHolder, 54, this.title.getString() + " [" + page + "]") : new InventoryBuilder(this.inventoryHolder, 54, this.title.getString());
        page = (page - 1) * 45;
        for (int a2 = 0; a2 < builder.getSize() - 9 && page != this.items.size() && !this.items.isEmpty(); ++a2, ++page) {
            builder.setItem(a2, this.items.get(page));
        }
        int finalPage = this.page;
        if (page != this.items.size()) {
            builder.setArrowRight((IChatBaseComponent)this.nextText, "scroll-next-" + this.title.getString() + "-" + page, event -> this.getInventory(finalPage + 1).openAsNMS(event.getWhoClicked(), this.getTitle()));
        }
        if (this.arrowBackEvent != null && this.page == 1) {
            builder.setArrowLeft((IChatBaseComponent)this.backText, (String)this.arrowBackEvent.getFirst(), (Consumer)this.arrowBackEvent.getSecond());
        } else {
            builder.setArrowLeft((IChatBaseComponent)this.backText, "scroll-back-" + this.title.getString() + "-" + page, event -> {
                if (finalPage == 1) {
                    if (InventorySaver.isInventoryView(event.getWhoClicked(), 1)) {
                        event.getWhoClicked().openInventory(InventorySaver.getInventoryView(event.getWhoClicked(), 1).getTopInventory());
                    } else {
                        event.getWhoClicked().closeInventory();
                    }
                } else {
                    this.getInventory(finalPage - 1).openAsNMS(event.getWhoClicked(), this.getTitle());
                }
            });
        }
        for (Hotbar hotbar : this.hotbars) {
            if (hotbar == null) continue;
            builder.setItem(46 + hotbar.getSlot(), hotbar.getItem());
        }
        return builder.normal();
    }

    public boolean isShowPage() {
        return this.showPage;
    }

    public ScrollInventory setItems(List<ItemStack> items) {
        this.items = new ArrayList<ItemStack>(items);
        return this;
    }

    public void replaceSimple(ItemStack i1, ItemStack i2) {
        this.items.stream().filter(itemStack -> itemStack.isSimilar(i1)).forEach(itemStack -> this.items.set(this.items.indexOf(itemStack), i2));
    }

    public IChatBaseComponent getTitle() {
        if (this.isShowPage()) {
            return this.title.f().b((IChatBaseComponent)IChatBaseComponent.b((String)(" [" + this.page + "]")));
        }
        return this.title;
    }

    public int getPage() {
        return this.page;
    }

    public boolean isEmpty() {
        return this.page != 1 && (this.page - 1) * 45 >= this.items.size();
    }

    public Inventory start() {
        return this.getInventory(1).build();
    }

    public record Hotbar(int slot, ItemStack item) {
        public ItemStack getItem() {
            return this.item;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

