/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo;

import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.bingo.settings.AllowEnchantmentsSetting;
import de.eisi05.bingo.bingo.settings.AmountOfObjectsSetting;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.DamageSetting;
import de.eisi05.bingo.bingo.settings.DifficultySetting;
import de.eisi05.bingo.bingo.settings.EndSetting;
import de.eisi05.bingo.bingo.settings.NetherSetting;
import de.eisi05.bingo.bingo.settings.ObjectTypesSetting;
import de.eisi05.bingo.bingo.settings.PVPSetting;
import de.eisi05.bingo.bingo.settings.RandomizerSetting;
import de.eisi05.bingo.manager.RandomizeManager;
import de.eisi05.bingo.utils.BingoData;
import de.eisi05.bingo.utils.BingoDifficulty;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.builder.StringBuilder;
import de.eisi05.bingo.utils.eisutils.inventory.ItemSerialization;
import de.eisi05.bingo.utils.eisutils.lists.AdvancementList;
import de.eisi05.bingo.utils.eisutils.lists.BiomeList;
import de.eisi05.bingo.utils.eisutils.lists.EntityList;
import de.eisi05.bingo.utils.eisutils.lists.ItemList;
import de.eisi05.bingo.utils.eisutils.lists.StructureList;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.MinecraftExperimental;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;

public abstract sealed class BingoObject<T>
implements Serializable {
    public static List<BingoObject<?>> bingoObjects = new ArrayList();
    private static List<BingoObject<?>> selectedObjects;
    protected final T object;
    protected BingoDifficulty bingoDifficulty;

    public BingoObject(T object, BingoDifficulty bingoDifficulty) {
        this.object = object;
        this.bingoDifficulty = bingoDifficulty;
        if (!this.getClass().equals(BingoItem.EnchantedBingoItem.class)) {
            bingoObjects.add(this);
        }
    }

    public static List<BingoObject<?>> getAvailableObjects() {
        return bingoObjects.stream().filter(bingoObject -> {
            if (!((Boolean)BingoSetting.getSetting(NetherSetting.class).getValue()).booleanValue() && (bingoObject.isNetherObject() || bingoObject.isEndObject())) {
                return false;
            }
            if (!((Boolean)BingoSetting.getSetting(EndSetting.class).getValue()).booleanValue() && bingoObject.isEndObject()) {
                return false;
            }
            if (!((List)BingoSetting.getSetting(ObjectTypesSetting.class).getValue()).contains(bingoObject.getClass())) {
                return false;
            }
            return bingoObject.getDifficulty().ordinal() <= ((BingoDifficulty)BingoSetting.getSetting(DifficultySetting.class).getValue()).ordinal();
        }).toList();
    }

    public static List<BingoObject<?>> getSelectedObjects() {
        return selectedObjects;
    }

    public static CompletableFuture<Void> calculateNewSelectedObjects() {
        if (((Boolean)BingoSetting.getSetting(RandomizerSetting.class).getValue()).booleanValue()) {
            BingoSetting.getSetting(DifficultySetting.class).setValue(BingoDifficulty.HARD);
            BingoSetting.getSetting(EndSetting.class).setValue(true);
            BingoSetting.getSetting(NetherSetting.class).setValue(true);
            RandomizeManager.createMapping();
        }
        ArrayList availableObjects = new ArrayList(BingoObject.getAvailableObjects());
        if (((Boolean)BingoSetting.getSetting(AllowEnchantmentsSetting.class).getValue()).booleanValue()) {
            ArrayList enchantedItems = new ArrayList();
            availableObjects.forEach(bingoObject -> {
                if (!(bingoObject instanceof BingoItem)) {
                    return;
                }
                BingoItem item = (BingoItem)bingoObject;
                List<Enchantment> enchantments = ItemList.getAvailableEnchantments(((ItemStack)item.getObject()).clone());
                if (enchantments.isEmpty()) {
                    return;
                }
                Enchantment enchantment = enchantments.get(new Random().nextInt(enchantments.size()));
                ItemStack enchantedItem = ((ItemStack)item.getObject()).clone();
                enchantedItem.addUnsafeEnchantment(enchantment, 1);
                enchantedItems.add(new BingoItem.EnchantedBingoItem(enchantedItem, bingoObject.getDifficulty()));
            });
            availableObjects.addAll(enchantedItems);
        }
        int amount = (Integer)BingoSetting.getSetting(AmountOfObjectsSetting.class).getValue();
        Collections.shuffle(availableObjects);
        selectedObjects = new ArrayList(availableObjects.subList(0, amount));
        if (selectedObjects.stream().anyMatch(bingoObject -> bingoObject.getObject().equals(EntityType.PLAYER))) {
            BingoSetting.getSetting(PVPSetting.class).setValue(true);
        }
        if (selectedObjects.stream().anyMatch(bingoObject -> {
            if (!(bingoObject instanceof BingoAdvancement)) {
                return false;
            }
            BingoAdvancement advancement = (BingoAdvancement)bingoObject;
            return ((Advancement)advancement.object).getKey().getKey().equals("adventure/totem_of_undying");
        })) {
            BingoSetting.getSetting(DamageSetting.class).setValue(true);
        }
        return CompletableFuture.completedFuture(null);
    }

    public static void loadBingoObjects() {
        ItemList.itemStacks.stream().filter(itemStack -> !ItemList.notObtainableInSurvival.contains(itemStack.getType())).filter(itemStack -> BingoObject.getBingoObjects(BingoItem.class).stream().noneMatch(bingoObject -> bingoObject.compare((ItemStack)BingoObject.cast(itemStack)))).forEach(itemStack -> {
            BingoDifficulty bingoDifficulty;
            if (itemStack.getItemMeta().hasRarity()) {
                switch (itemStack.getItemMeta().getRarity()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case COMMON: {
                        bingoDifficulty = BingoDifficulty.EASY;
                        break;
                    }
                    case UNCOMMON: 
                    case RARE: {
                        bingoDifficulty = BingoDifficulty.NORMAL;
                        break;
                    }
                    case EPIC: {
                        bingoDifficulty = BingoDifficulty.HARD;
                        break;
                    }
                }
            } else {
                bingoDifficulty = BingoDifficulty.EASY;
            }
            new BingoItem((ItemStack)itemStack, bingoDifficulty);
        });
        Arrays.stream(Biome.class.getDeclaredFields()).filter(field -> field.getType().equals(Biome.class)).filter(field -> !field.getName().equalsIgnoreCase("CUSTOM")).filter(field -> !field.isAnnotationPresent(MinecraftExperimental.class)).map(field -> {
            try {
                return (Biome)field.get(null);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }).filter(Objects::nonNull).filter(biome -> BingoObject.getBingoObjects(BingoBiome.class).stream().noneMatch(bingoObject -> bingoObject.compare((Biome)BingoObject.cast(biome)))).forEach(biome -> new BingoBiome((Biome)biome, BiomeList.netherBiomes.contains(biome) ? BingoDifficulty.NORMAL : (BiomeList.endBiomes.contains(biome) ? BingoDifficulty.HARD : BingoDifficulty.EASY)));
        Bukkit.advancementIterator().forEachRemaining(advancement -> {
            if (advancement.getDisplay() == null) {
                return;
            }
            if (advancement.getParent() == null) {
                return;
            }
            if (BingoObject.getBingoObjects(BingoAdvancement.class).stream().anyMatch(bingoObject -> bingoObject.compare((Advancement)BingoObject.cast(advancement)))) {
                return;
            }
            new BingoAdvancement((Advancement)advancement, AdvancementList.netherAdvancements.contains(advancement) ? BingoDifficulty.NORMAL : (AdvancementList.endAdvancements.contains(advancement) ? BingoDifficulty.HARD : BingoDifficulty.EASY));
        });
        RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE).stream().filter(structure -> BingoObject.getBingoObjects(BingoStructure.class).stream().noneMatch(bingoObject -> bingoObject.compare((Structure)BingoObject.cast(structure)))).forEach(structure -> new BingoStructure((Structure)structure, StructureList.netherStructures.contains(structure) ? BingoDifficulty.NORMAL : (StructureList.endStructures.contains(structure) ? BingoDifficulty.HARD : BingoDifficulty.EASY)));
        Arrays.stream(EntityType.values()).forEach(entityType -> {
            if (entityType.getEntityClass() == null) {
                return;
            }
            if (entityType.getEntityClass().isAnnotationPresent(MinecraftExperimental.class)) {
                return;
            }
            if (BingoObject.getBingoObjects(BingoEntity.class).stream().anyMatch(bingoObject -> bingoObject.compare((EntityType)BingoObject.cast(entityType)))) {
                return;
            }
            if (entityType == EntityType.ILLUSIONER || entityType == EntityType.GIANT || entityType == EntityType.ZOMBIE_HORSE) {
                return;
            }
            if (LivingEntity.class.isAssignableFrom(entityType.getEntityClass())) {
                new BingoEntity((EntityType)entityType, EntityList.netherEntities.contains(entityType) ? BingoDifficulty.NORMAL : (EntityList.endEntities.contains(entityType) ? BingoDifficulty.HARD : BingoDifficulty.EASY));
            }
        });
    }

    public static Component getName(Class<? extends BingoObject<?>> clazz) {
        return Component.translatable((String)clazz.getAnnotation(BingoData.class).key(), (String)clazz.getAnnotation(BingoData.class).fallback());
    }

    public static Material getIcon(Class<? extends BingoObject<?>> clazz) {
        return clazz.getAnnotation(BingoData.class).icon();
    }

    public static Class<? extends BingoObject<?>>[] getClasses() {
        return Arrays.stream(BingoObject.class.getPermittedSubclasses()).map(aClass -> aClass).toList().toArray(new Class[0]);
    }

    public static <T> List<BingoObject<T>> getBingoObjects(Class<? extends BingoObject<T>> c) {
        return bingoObjects.stream().filter(bingoObject -> bingoObject.getClass().isAssignableFrom(c)).map(c::cast).map(tBingoObject -> tBingoObject).filter(Objects::nonNull).toList();
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    public abstract boolean isSimilarObject(T var1);

    public abstract Component getFoundVerb();

    protected abstract ItemStack asDisplay();

    public abstract Component getName();

    public abstract Component getScoreboardIcon();

    public abstract boolean isNetherObject();

    public abstract boolean isEndObject();

    abstract boolean compare(T var1);

    public ItemStack asDisplayIcon() {
        ItemRarity rarity = this.isNetherObject() ? ItemRarity.EPIC : (this.isEndObject() ? ItemRarity.UNCOMMON : ItemRarity.COMMON);
        return new ItemBuilder(this.asDisplay().clone()).setRarity(rarity).build();
    }

    abstract String serialize();

    public BingoDifficulty getDifficulty() {
        return this.bingoDifficulty;
    }

    public void setDifficulty(BingoDifficulty bingoDifficulty) {
        this.bingoDifficulty = bingoDifficulty;
    }

    public T getObject() {
        return this.object;
    }

    public Class<?> getObjectClass() {
        return this.object.getClass();
    }

    public SerializedBingoObject<T> toSerializedBingoObject() {
        return new SerializedBingoObject(this);
    }

    public boolean hasFound(BingoTeam team) {
        return !team.getMissingBingoItems().contains(this);
    }

    @BingoData(key="de.eisi05.bingo.object.item", fallback="Item", icon=Material.DIAMOND)
    public static sealed class BingoItem
    extends BingoObject<ItemStack> {
        public BingoItem(ItemStack object, BingoDifficulty bingoDifficulty) {
            super(object, bingoDifficulty);
        }

        public BingoItem(String object, BingoDifficulty bingoDifficulty) {
            this(ItemSerialization.itemStackFromBase64(object), bingoDifficulty);
        }

        @Override
        public boolean isSimilarObject(ItemStack itemStack) {
            return itemStack.getType() == ((ItemStack)this.object).getType();
        }

        @Override
        public Component getFoundVerb() {
            return Component.translatable((String)"de.eisi05.bingo.collected", (String)"collected");
        }

        @Override
        public ItemStack asDisplay() {
            return new ItemBuilder(((ItemStack)this.object).clone()).clearAttributes().build();
        }

        @Override
        public Component getName() {
            return Component.translatable((String)((ItemStack)this.object).translationKey(), (String)new StringBuilder(((ItemStack)this.object).getType().name()).toNormalCase().build());
        }

        @Override
        public Component getScoreboardIcon() {
            return BingoUtils.getItemIcon(((ItemStack)this.object).getType(), Component.text((String)"-").color((TextColor)NamedTextColor.DARK_GRAY));
        }

        @Override
        public boolean isEndObject() {
            return ItemList.endItems.contains(((ItemStack)this.object).getType());
        }

        @Override
        boolean compare(ItemStack object) {
            if (this.object == null || object == null) {
                return false;
            }
            return object.getType() == ((ItemStack)this.object).getType();
        }

        @Override
        public boolean isNetherObject() {
            return ItemList.netherItems.contains(((ItemStack)this.object).getType());
        }

        @Override
        String serialize() {
            return ItemSerialization.itemStackToBase64((ItemStack)this.object);
        }

        @BingoData(key="de.eisi05.bingo.object.enchantedItem", fallback="Enchanted Item", icon=Material.ENCHANTED_BOOK)
        public static final class EnchantedBingoItem
        extends BingoItem {
            public EnchantedBingoItem(ItemStack object, BingoDifficulty bingoDifficulty) {
                super(object, bingoDifficulty);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean isSimilarObject(ItemStack itemStack) {
                if (itemStack.getType() != ((ItemStack)this.object).getType()) return false;
                if (((ItemStack)this.object).getEnchantments().keySet().stream().filter(arg_0 -> ((ItemStack)itemStack).containsEnchantment(arg_0)).count() != (long)((ItemStack)this.object).getEnchantments().size()) return false;
                return true;
            }
        }
    }

    public static class SerializedBingoObject<T>
    implements Serializable {
        private final String object;
        private final BingoDifficulty difficulty;
        private final Class<BingoObject<T>> clazz;

        private SerializedBingoObject(BingoObject<T> toSerialize) {
            this.object = toSerialize.serialize();
            this.difficulty = toSerialize.getDifficulty();
            this.clazz = toSerialize.getClass();
        }

        public void toBingoObject() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            this.clazz.getConstructor(String.class, BingoDifficulty.class).newInstance(this.object, this.difficulty);
        }
    }

    @BingoData(key="de.eisi05.bingo.object.entity", fallback="Entity", icon=Material.ZOMBIE_HEAD)
    public static final class BingoEntity
    extends BingoObject<EntityType> {
        public BingoEntity(EntityType object, BingoDifficulty bingoDifficulty) {
            super(object, bingoDifficulty);
        }

        public BingoEntity(String object, BingoDifficulty bingoDifficulty) {
            super(EntityType.valueOf((String)object), bingoDifficulty);
        }

        @Override
        public boolean isSimilarObject(EntityType entityType) {
            return this.object == entityType;
        }

        @Override
        public Component getFoundVerb() {
            return Component.translatable((String)"de.eisi05.bingo.killed", (String)"killed");
        }

        @Override
        public ItemStack asDisplay() {
            return new ItemBuilder(this.getMaterial()).setName(this.getName()).clearAttributes().flags().build();
        }

        private Material getMaterial() {
            return switch ((EntityType)this.object) {
                case EntityType.PLAYER -> Material.PLAYER_HEAD;
                case EntityType.ARMOR_STAND -> Material.ARMOR_STAND;
                default -> Material.valueOf((String)(((EntityType)this.object).name() + "_SPAWN_EGG"));
            };
        }

        @Override
        public Component getName() {
            return Component.translatable((String)((EntityType)this.object).translationKey(), (String)new StringBuilder(((EntityType)this.object).name()).toNormalCase().build());
        }

        @Override
        public Component getScoreboardIcon() {
            return BingoUtils.getEntityIcon((EntityType)this.object, Component.text((String)"-").color((TextColor)NamedTextColor.DARK_GRAY));
        }

        @Override
        public boolean isEndObject() {
            return EntityList.endEntities.contains(this.object);
        }

        @Override
        boolean compare(EntityType object) {
            return object.name().contains(((EntityType)this.object).name());
        }

        @Override
        public boolean isNetherObject() {
            return EntityList.netherEntities.contains(this.object);
        }

        @Override
        String serialize() {
            return ((EntityType)this.object).name();
        }
    }

    @BingoData(key="de.eisi05.bingo.object.structure", fallback="Structure", icon=Material.STRUCTURE_BLOCK)
    public static final class BingoStructure
    extends BingoObject<Structure> {
        public BingoStructure(Structure object, BingoDifficulty bingoDifficulty) {
            super(object, bingoDifficulty);
        }

        public BingoStructure(String object, BingoDifficulty bingoDifficulty) {
            super((Structure)RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE).get(NamespacedKey.minecraft((String)object)), bingoDifficulty);
        }

        @Override
        public boolean isSimilarObject(Structure structure) {
            return ((Structure)this.object).equals(structure);
        }

        @Override
        public Component getFoundVerb() {
            return Component.translatable((String)"de.eisi05.bingo.found", (String)"found");
        }

        @Override
        public ItemStack asDisplay() {
            return new ItemBuilder(((Structure)this.object).getStructureType() == StructureType.STRONGHOLD ? Material.ENDER_EYE : StructureList.structureMap.getFirstOrDefault((Structure)this.object, Material.STRUCTURE_BLOCK)).setName((Component)Component.text((String)new StringBuilder(RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE).getKey((Keyed)((Structure)this.object)).getKey()).toNormalCase().build())).clearAttributes().flags().build();
        }

        @Override
        public Component getName() {
            return Component.text((String)new StringBuilder(RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE).getKey((Keyed)((Structure)this.object)).getKey()).toNormalCase().build());
        }

        @Override
        public Component getScoreboardIcon() {
            String biome = String.valueOf(StructureList.structureMap.getSecondOrDefault((Structure)this.object, null));
            return biome == null ? Component.text((String)"-").color((TextColor)NamedTextColor.DARK_GRAY) : Component.text((String)biome);
        }

        @Override
        public boolean isEndObject() {
            return StructureList.endStructures.stream().anyMatch(((Structure)this.object)::equals);
        }

        @Override
        boolean compare(Structure object) {
            return object.equals(this.object);
        }

        @Override
        public boolean isNetherObject() {
            return StructureList.netherStructures.stream().anyMatch(structure -> structure.equals(this.object));
        }

        @Override
        String serialize() {
            return RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE).getKey((Keyed)((Structure)this.object)).getKey();
        }
    }

    @BingoData(key="de.eisi05.bingo.object.advancement", fallback="Advancement", icon=Material.PAPER)
    public static final class BingoAdvancement
    extends BingoObject<Advancement> {
        public BingoAdvancement(Advancement object, BingoDifficulty bingoDifficulty) {
            super(object, bingoDifficulty);
        }

        public BingoAdvancement(String object, BingoDifficulty bingoDifficulty) {
            super(Bukkit.getAdvancement((NamespacedKey)NamespacedKey.minecraft((String)object)), bingoDifficulty);
        }

        @Override
        public boolean isSimilarObject(Advancement advancement) {
            return ((Advancement)this.object).getKey().equals((Object)advancement.getKey());
        }

        @Override
        public Component getFoundVerb() {
            return Component.translatable((String)"de.eisi05.bingo.completed", (String)"completed");
        }

        @Override
        public ItemStack asDisplay() {
            return new ItemBuilder(((Advancement)this.object).getDisplay().icon()).clearAttributes().setName(this.getName()).setLore(new Component[]{Component.translatable((String)("advancements." + ((Advancement)this.object).getKey().getKey().replace("/", ".") + ".description"), (String)PlainTextComponentSerializer.plainText().serialize(((Advancement)this.object).getDisplay().description()))}).flags().build();
        }

        @Override
        public Component getName() {
            return Component.translatable((String)("advancements." + ((Advancement)this.object).getKey().getKey().replace("/", ".") + ".title"), (String)PlainTextComponentSerializer.plainText().serialize(((Advancement)this.object).getDisplay().title()));
        }

        @Override
        public Component getScoreboardIcon() {
            return BingoUtils.getItemIcon(((Advancement)this.object).getDisplay().icon().getType(), Component.text((String)"-").color((TextColor)NamedTextColor.DARK_GRAY));
        }

        @Override
        public boolean isEndObject() {
            return AdvancementList.endAdvancements.stream().anyMatch(advancement -> advancement.getKey().getKey().equals(((Advancement)this.object).getKey().getKey()));
        }

        @Override
        boolean compare(Advancement object) {
            if (object == null || this.object == null) {
                return false;
            }
            return object.getKey().getKey().equals(((Advancement)this.object).getKey().getKey());
        }

        @Override
        public boolean isNetherObject() {
            return AdvancementList.netherAdvancements.stream().anyMatch(advancement -> advancement.getKey().getKey().equals(((Advancement)this.object).getKey().getKey()));
        }

        @Override
        String serialize() {
            if (this.object == null) {
                return null;
            }
            return ((Advancement)this.object).getKey().getKey();
        }
    }

    @BingoData(key="de.eisi05.bingo.object.biome", fallback="Biome", icon=Material.GRASS_BLOCK)
    public static final class BingoBiome
    extends BingoObject<Biome> {
        public BingoBiome(Biome object, BingoDifficulty bingoDifficulty) {
            super(object, bingoDifficulty);
        }

        public BingoBiome(String object, BingoDifficulty bingoDifficulty) throws NoSuchFieldException, IllegalAccessException {
            super((Biome)Biome.class.getDeclaredField(object.toUpperCase()).get(null), bingoDifficulty);
        }

        @Override
        public boolean isSimilarObject(Biome biome) {
            return this.object == biome;
        }

        @Override
        public Component getFoundVerb() {
            return Component.translatable((String)"de.eisi05.bingo.discovered", (String)"discovered");
        }

        @Override
        public ItemStack asDisplay() {
            return new ItemBuilder(BiomeList.biomeMap.getFirstOrDefault((Biome)this.object, Material.GRASS_BLOCK)).setName(this.getName()).clearAttributes().flags().build();
        }

        @Override
        public Component getName() {
            return Component.translatable((String)((Biome)this.object).translationKey(), (String)new StringBuilder(((Biome)this.object).getKey().getKey()).toNormalCase().build());
        }

        @Override
        public Component getScoreboardIcon() {
            String biome = String.valueOf(BiomeList.biomeMap.getSecondOrDefault((Biome)this.object, null));
            return biome == null ? Component.text((String)"-").color((TextColor)NamedTextColor.DARK_GRAY) : Component.text((String)biome);
        }

        @Override
        public boolean isEndObject() {
            return BiomeList.endBiomes.contains(this.object);
        }

        @Override
        boolean compare(Biome object) {
            return object.getKey().getKey().equals(((Biome)this.object).getKey().getKey());
        }

        @Override
        public boolean isNetherObject() {
            return BiomeList.netherBiomes.contains(this.object);
        }

        @Override
        String serialize() {
            return ((Biome)this.object).getKey().getKey().toUpperCase();
        }
    }
}

